/*
 * Decompiled with CFR 0.152.
 */
package rocks.frieler.kraftsql.bq.testing;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import rocks.frieler.kraftsql.bq.engine.BigQueryEngine;
import rocks.frieler.kraftsql.bq.expressions.JsonValue;
import rocks.frieler.kraftsql.bq.expressions.JsonValueArray;
import rocks.frieler.kraftsql.bq.expressions.Replace;
import rocks.frieler.kraftsql.bq.expressions.Timestamp;
import rocks.frieler.kraftsql.expressions.Expression;
import rocks.frieler.kraftsql.objects.DataRow;
import rocks.frieler.kraftsql.testing.engine.SimulatorConnection;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J0\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u0001H\n0\b\"\u0004\b\u0000\u0010\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\n0\fH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lrocks/frieler/kraftsql/bq/testing/BigQuerySimulatorConnection;", "Lrocks/frieler/kraftsql/testing/engine/SimulatorConnection;", "Lrocks/frieler/kraftsql/bq/engine/BigQueryEngine;", "<init>", "()V", "timestampLiteralPattern", "Ljava/util/regex/Pattern;", "simulateExpression", "Lkotlin/Function1;", "Lrocks/frieler/kraftsql/objects/DataRow;", "T", "expression", "Lrocks/frieler/kraftsql/expressions/Expression;", "kraftsql-bigquery-testing"})
@SourceDebugExtension(value={"SMAP\nBigQuerySimulatorConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BigQuerySimulatorConnection.kt\nrocks/frieler/kraftsql/bq/testing/BigQuerySimulatorConnection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,59:1\n1#2:60\n1563#3:61\n1634#3,3:62\n37#4:65\n36#4,3:66\n*S KotlinDebug\n*F\n+ 1 BigQuerySimulatorConnection.kt\nrocks/frieler/kraftsql/bq/testing/BigQuerySimulatorConnection\n*L\n54#1:61\n54#1:62,3\n54#1:65\n54#1:66,3\n*E\n"})
public final class BigQuerySimulatorConnection
extends SimulatorConnection<BigQueryEngine> {
    @NotNull
    private final Pattern timestampLiteralPattern;

    public BigQuerySimulatorConnection() {
        super(null, 1, null);
        String string = "^(?<date>\\d{4}-\\d{1,2}-\\d{1,2})[Tt ](?<time>\\d{1,2}:\\d{1,2}:\\d{1,2}(.\\d{1,6})?)?(?<tz>|[Zz]|[+-]\\d{1,2}(:\\d{2})?| .+/.+)$";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.timestampLiteralPattern = pattern;
    }

    @NotNull
    protected <T> Function1<DataRow, T> simulateExpression(@NotNull Expression<BigQueryEngine, T> expression) {
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        Expression<BigQueryEngine, T> expression2 = expression;
        return expression2 instanceof Replace ? arg_0 -> BigQuerySimulatorConnection.simulateExpression$lambda$0(this, expression, arg_0) : (expression2 instanceof Timestamp ? arg_0 -> BigQuerySimulatorConnection.simulateExpression$lambda$3(this, expression, arg_0) : (expression2 instanceof JsonValue ? arg_0 -> BigQuerySimulatorConnection.simulateExpression$lambda$5(this, expression, arg_0) : (expression2 instanceof JsonValueArray ? arg_0 -> BigQuerySimulatorConnection.simulateExpression$lambda$9(this, expression, arg_0) : super.simulateExpression(expression))));
    }

    private static final Object simulateExpression$lambda$0(BigQuerySimulatorConnection this$0, Expression $expression, DataRow row) {
        String string;
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        String originalValue = (String)this$0.simulateExpression(((Replace)$expression).getOriginalValue()).invoke((Object)row);
        Object object = this$0.simulateExpression(((Replace)$expression).getFromPattern()).invoke((Object)row);
        Intrinsics.checkNotNull((Object)object);
        String fromPattern = (String)object;
        if (((CharSequence)fromPattern).length() == 0) {
            string = originalValue;
        } else {
            Object object2 = this$0.simulateExpression(((Replace)$expression).getToPattern()).invoke((Object)row);
            Intrinsics.checkNotNull((Object)object2);
            String toPattern = (String)object2;
            String string2 = originalValue;
            string = string2 != null ? StringsKt.replace$default((String)string2, (String)fromPattern, (String)toPattern, (boolean)false, (int)4, null) : null;
        }
        return string;
    }

    private static final Object simulateExpression$lambda$3(BigQuerySimulatorConnection this$0, Expression $expression, DataRow row) {
        Instant instant;
        String timestamp;
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        String string = timestamp = (String)this$0.simulateExpression(((Timestamp)$expression).getStringExpression()).invoke((Object)row);
        if (string != null) {
            String string2;
            CharSequence charSequence;
            String it = string;
            boolean bl = false;
            Matcher matcher = this$0.timestampLiteralPattern.matcher(it);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("invalid timestamp format: " + it);
            }
            String string3 = matcher.group("date");
            String string4 = matcher.group("time");
            if (string4 == null) {
                string4 = "00:00:00.000000";
            }
            String string5 = matcher.group("tz");
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"group(...)");
            CharSequence charSequence2 = ((Object)StringsKt.trim((CharSequence)string5)).toString();
            if (charSequence2.length() == 0) {
                String string6 = string4;
                String string7 = string3;
                boolean bl2 = false;
                Object var11_11 = null;
                string3 = string7;
                string4 = string6;
                charSequence = var11_11;
            } else {
                charSequence = charSequence2;
            }
            if ((string2 = (String)charSequence) == null) {
                string2 = "Z";
            }
            String canonicalTimestamp = string3 + "T" + string4 + string2;
            instant = Instant.parse(canonicalTimestamp);
        } else {
            instant = null;
        }
        return instant;
    }

    private static final Object simulateExpression$lambda$5(BigQuerySimulatorConnection this$0, Expression $expression, DataRow row) {
        String jsonPath;
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        String jsonString = (String)this$0.simulateExpression(((JsonValue)$expression).getJsonString()).invoke((Object)row);
        Expression expression = ((JsonValue)$expression).getJsonPath();
        if (expression != null) {
            Expression it = expression;
            boolean bl = false;
            string2 = (String)this$0.simulateExpression(it).invoke((Object)row);
        } else {
            string2 = null;
        }
        if ((string = (jsonPath = string2)) == null) {
            string = "$";
        }
        return JsonPath.read((String)jsonString, (String)string, (Predicate[])new Predicate[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object simulateExpression$lambda$9(BigQuerySimulatorConnection this$0, Expression $expression, DataRow row) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        String jsonPath;
        String string;
        String string2;
        Object it;
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        String it2 = (String)this$0.simulateExpression(((JsonValueArray)$expression).getJsonString()).invoke((Object)row);
        boolean bl = false;
        CharSequence charSequence = it2;
        String jsonString = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "[]" : it2;
        Expression expression = ((JsonValueArray)$expression).getJsonPath();
        if (expression != null) {
            it = expression;
            boolean bl2 = false;
            string2 = (String)this$0.simulateExpression((Expression)it).invoke((Object)row);
        } else {
            string2 = null;
        }
        if ((string = (jsonPath = string2)) == null) {
            string = "$";
        }
        Object object = JsonPath.read((String)jsonString, (String)string, (Predicate[])new Predicate[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"read(...)");
        Iterable $this$map$iv = (Iterable)object;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it3;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it3.toString());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }
}

