/*
 * Decompiled with CFR 0.152.
 */
package rocks.frieler.kraftsql.bq.testing.engine;

import java.io.Closeable;
import java.io.FileReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URI;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rocks.frieler.kraftsql.bq.dml.LoadData;
import rocks.frieler.kraftsql.bq.engine.BigQueryConnection;
import rocks.frieler.kraftsql.bq.engine.BigQueryEngine;
import rocks.frieler.kraftsql.bq.objects.TemporaryTable;
import rocks.frieler.kraftsql.bq.testing.engine.BigQuerySimulatorORMapping;
import rocks.frieler.kraftsql.bq.testing.engine.ConstantSimulator;
import rocks.frieler.kraftsql.bq.testing.engine.JsonValueArraySimulator;
import rocks.frieler.kraftsql.bq.testing.engine.JsonValueSimulator;
import rocks.frieler.kraftsql.bq.testing.engine.ReplaceSimulator;
import rocks.frieler.kraftsql.bq.testing.engine.StructSimulator;
import rocks.frieler.kraftsql.bq.testing.engine.TimestampSimulator;
import rocks.frieler.kraftsql.ddl.CreateTable;
import rocks.frieler.kraftsql.ddl.DropTable;
import rocks.frieler.kraftsql.dml.BeginTransaction;
import rocks.frieler.kraftsql.dml.Delete;
import rocks.frieler.kraftsql.dml.InsertInto;
import rocks.frieler.kraftsql.dml.RollbackTransaction;
import rocks.frieler.kraftsql.dql.Select;
import rocks.frieler.kraftsql.expressions.Constant;
import rocks.frieler.kraftsql.expressions.Row;
import rocks.frieler.kraftsql.objects.Column;
import rocks.frieler.kraftsql.objects.DataRow;
import rocks.frieler.kraftsql.objects.Table;
import rocks.frieler.kraftsql.testing.engine.EngineState;
import rocks.frieler.kraftsql.testing.engine.ExpressionSimulator;
import rocks.frieler.kraftsql.testing.engine.GenericSimulatorConnection;
import rocks.frieler.kraftsql.testing.engine.SimulatorORMapping;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\f0\u000b\"\b\b\u0000\u0010\f*\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\f0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\f0\u0011H\u0016J\u0016\u0010\n\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0016J\u0016\u0010\n\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016H\u0016J\u001a\u0010\n\u001a\u00020\u00172\u0010\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u0003\u0012\u0002\b\u00030\u0019H\u0016J\u0016\u0010\n\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bH\u0016J\u0010\u0010\n\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\n\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010!\u001a\u00020\u0012H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lrocks/frieler/kraftsql/bq/testing/engine/BigQuerySimulatorConnection;", "Lrocks/frieler/kraftsql/bq/engine/BigQueryConnection;", "Lrocks/frieler/kraftsql/testing/engine/GenericSimulatorConnection;", "Lrocks/frieler/kraftsql/bq/engine/BigQueryEngine;", "<init>", "()V", "sessionMode", "", "activeSession", "Lrocks/frieler/kraftsql/bq/testing/engine/BigQuerySimulatorConnection$SessionState;", "execute", "", "T", "", "select", "Lrocks/frieler/kraftsql/dql/Select;", "type", "Lkotlin/reflect/KClass;", "", "createTable", "Lrocks/frieler/kraftsql/ddl/CreateTable;", "dropTable", "Lrocks/frieler/kraftsql/ddl/DropTable;", "", "insertInto", "Lrocks/frieler/kraftsql/dml/InsertInto;", "delete", "Lrocks/frieler/kraftsql/dml/Delete;", "loadData", "Lrocks/frieler/kraftsql/bq/dml/LoadData;", "beginTransaction", "Lrocks/frieler/kraftsql/dml/BeginTransaction;", "setSessionMode", "ensureSession", "SessionState", "kraftsql-bigquery-testing"})
@SourceDebugExtension(value={"SMAP\nBigQuerySimulatorConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BigQuerySimulatorConnection.kt\nrocks/frieler/kraftsql/bq/testing/engine/BigQuerySimulatorConnection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,195:1\n1#2:196\n1563#3:197\n1634#3,3:198\n1869#3,2:203\n1193#3,2:205\n1267#3,4:207\n37#4,2:201\n*S KotlinDebug\n*F\n+ 1 BigQuerySimulatorConnection.kt\nrocks/frieler/kraftsql/bq/testing/engine/BigQuerySimulatorConnection\n*L\n128#1:197\n128#1:198,3\n134#1:203,2\n140#1:205,2\n140#1:207,4\n128#1:201,2\n*E\n"})
public final class BigQuerySimulatorConnection
extends GenericSimulatorConnection<BigQueryEngine>
implements BigQueryConnection {
    private boolean sessionMode;
    @Nullable
    private SessionState activeSession;

    public BigQuerySimulatorConnection() {
        super((SimulatorORMapping)BigQuerySimulatorORMapping.INSTANCE, null, 2, null);
        this.unregisterExpressionSimulator(Reflection.getOrCreateKotlinClass(Constant.class));
        this.registerExpressionSimulator((ExpressionSimulator)new ConstantSimulator());
        this.unregisterExpressionSimulator(Reflection.getOrCreateKotlinClass(Row.class));
        this.registerExpressionSimulator((ExpressionSimulator)new StructSimulator());
        this.registerExpressionSimulator(new ReplaceSimulator());
        this.registerExpressionSimulator(new TimestampSimulator());
        this.registerExpressionSimulator(new JsonValueSimulator());
        this.registerExpressionSimulator(new JsonValueArraySimulator());
    }

    @NotNull
    public <T> List<T> execute(@NotNull Select<BigQueryEngine, T> select, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter(select, (String)"select");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (this.sessionMode) {
            this.ensureSession();
        }
        return super.execute(select, type);
    }

    public void execute(@NotNull CreateTable<BigQueryEngine> createTable) {
        Intrinsics.checkNotNullParameter(createTable, (String)"createTable");
        if (createTable.getTable() instanceof TemporaryTable) {
            throw new UnsupportedOperationException("The BigQuery API does not support creation of temporary tables.");
        }
        super.execute(createTable);
    }

    public void execute(@NotNull DropTable<BigQueryEngine> dropTable) {
        Intrinsics.checkNotNullParameter(dropTable, (String)"dropTable");
        if (dropTable.getTable() instanceof TemporaryTable) {
            throw new UnsupportedOperationException("The BigQuery API does not support dropping temporary tables.");
        }
        super.execute(dropTable);
    }

    public int execute(@NotNull InsertInto<BigQueryEngine, ?> insertInto) {
        Intrinsics.checkNotNullParameter(insertInto, (String)"insertInto");
        if (this.sessionMode) {
            this.ensureSession();
        }
        return super.execute(insertInto);
    }

    public int execute(@NotNull Delete<BigQueryEngine> delete) {
        Intrinsics.checkNotNullParameter(delete, (String)"delete");
        if (this.sessionMode) {
            this.ensureSession();
        }
        return super.execute(delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execute(@NotNull LoadData loadData) {
        void $this$toTypedArray$iv;
        Column column;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)loadData, (String)"loadData");
        if (!Intrinsics.areEqual((Object)loadData.getFileSource().getFormat(), (Object)"CSV")) {
            throw new NotImplementedError("Loading data in '" + loadData.getFileSource().getFormat() + "' format is not yet supported.");
        }
        if (loadData.getColumns() == null) {
            throw new NotImplementedError("Loading data with auto-detection of the schema is not yet supported.");
        }
        if (!(!(loadData.getTable() instanceof TemporaryTable) || this.sessionMode)) {
            boolean $i$a$-check-BigQuerySimulatorConnection$execute$22 = false;
            String $i$a$-check-BigQuerySimulatorConnection$execute$22 = "Loading data into a temporary table would require a session, but session mode is turned off.";
            throw new IllegalStateException($i$a$-check-BigQuerySimulatorConnection$execute$22.toString());
        }
        if (this.sessionMode) {
            this.ensureSession();
        }
        if (loadData.getOverwrite()) {
            if (this.getTopState().containsTable(loadData.getTable().getQualifiedName())) {
                this.getTopState().removeTable((Table)loadData.getTable());
            }
            this.getTopState().addTable((Table)loadData.getTable());
        } else if (!this.getTopState().containsTable(loadData.getTable().getQualifiedName())) {
            this.getTopState().addTable((Table)loadData.getTable());
        }
        Pair pair = this.getTopState().getTable(loadData.getTable().getQualifiedName());
        Table table = (Table)pair.component1();
        List data = (List)pair.component2();
        CSVFormat.Builder builder = CSVFormat.DEFAULT.builder();
        List list = loadData.getColumns();
        Intrinsics.checkNotNull((Object)list);
        Iterable iterable = list;
        CSVFormat.Builder builder2 = builder;
        boolean $i$f$map = false;
        void var9_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            column = (Column)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        CSVFormat.Builder builder3 = thisCollection$iv.toArray(new String[0]);
        CSVFormat.Builder $this$execute_u24lambda_u242 = builder3 = builder2.setHeader(Arrays.copyOf(builder3, ((String[])builder3).length)).setLenientEof(true);
        boolean bl = false;
        String string = loadData.getFileSource().getFieldDelimiter();
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$execute_u24lambda_u242.setDelimiter(it);
        }
        CSVFormat.Builder $this$execute_u24lambda_u243 = builder3;
        boolean bl3 = false;
        Character c = loadData.getFileSource().getQuote();
        if (c != null) {
            char it = c.charValue();
            boolean bl4 = false;
            $this$execute_u24lambda_u243.setQuote(it);
        }
        CSVFormat csvFormat = builder3.setNullString("").get();
        Iterable $this$forEach$iv = loadData.getFileSource().getUris();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            URI uri = (URI)element$iv;
            boolean bl5 = false;
            Closeable closeable = new FileReader(uri.getPath());
            Throwable throwable = null;
            try {
                FileReader file = (FileReader)closeable;
                boolean bl6 = false;
                Stream records = csvFormat.parse((Reader)file).stream();
                Integer n = loadData.getFileSource().getSkipLeadingRows();
                records.skip(n != null ? (long)n.intValue() : 0L).map(arg_0 -> BigQuerySimulatorConnection.execute$lambda$4$0$1(arg_0 -> BigQuerySimulatorConnection.execute$lambda$4$0$0(table, loadData, arg_0), arg_0)).forEach(arg_0 -> BigQuerySimulatorConnection.execute$lambda$4$0$3(arg_0 -> BigQuerySimulatorConnection.execute$lambda$4$0$2(data, arg_0), arg_0));
                column = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    public void execute(@NotNull BeginTransaction<BigQueryEngine> beginTransaction) {
        Unit unit;
        Intrinsics.checkNotNullParameter(beginTransaction, (String)"beginTransaction");
        if (!(!(this.getTopState() instanceof GenericSimulatorConnection.TransactionStateOverlay))) {
            boolean $i$a$-check-BigQuerySimulatorConnection$execute$52 = false;
            String $i$a$-check-BigQuerySimulatorConnection$execute$52 = "There is already an open transaction and nested transactions are not supported.";
            throw new IllegalStateException($i$a$-check-BigQuerySimulatorConnection$execute$52.toString());
        }
        if (!this.sessionMode) {
            boolean $i$a$-check-BigQuerySimulatorConnection$execute$62 = false;
            String $i$a$-check-BigQuerySimulatorConnection$execute$62 = "Beginning a transaction would require a session, but session mode is turned off.";
            throw new IllegalStateException($i$a$-check-BigQuerySimulatorConnection$execute$62.toString());
        }
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        this.ensureSession();
        super.execute(beginTransaction);
    }

    public void setSessionMode(boolean sessionMode) {
        if (!sessionMode && this.activeSession != null) {
            if (this.getTopState() instanceof GenericSimulatorConnection.TransactionStateOverlay) {
                this.execute(new RollbackTransaction());
            }
            this.activeSession = null;
        }
        this.sessionMode = sessionMode;
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureSession() {
        BigQuerySimulatorConnection bigQuerySimulatorConnection = this;
        SessionState sessionState = this.activeSession;
        if (sessionState == null) {
            void it;
            SessionState sessionState2;
            SessionState sessionState3 = sessionState2 = new SessionState((EngineState<BigQueryEngine>)this.getRootState());
            BigQuerySimulatorConnection bigQuerySimulatorConnection2 = bigQuerySimulatorConnection;
            boolean bl = false;
            this.setTopState((EngineState)it);
            bigQuerySimulatorConnection = bigQuerySimulatorConnection2;
            sessionState = sessionState2;
        }
        bigQuerySimulatorConnection.activeSession = sessionState;
    }

    /*
     * WARNING - void declaration
     */
    private static final DataRow execute$lambda$4$0$0(Table $table, LoadData $loadData, CSVRecord record) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = $table.getColumns();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Comparable<Boolean> comparable;
            String string;
            Object v2;
            Iterable iterable2;
            String string2;
            Iterable iterable3;
            Column tableColumn;
            Map map;
            block20: {
                map = destination$iv$iv;
                tableColumn = (Column)element$iv$iv;
                boolean bl = false;
                String string3 = tableColumn.getName();
                List list = $loadData.getColumns();
                Intrinsics.checkNotNull((Object)list);
                iterable3 = list;
                string2 = string3;
                iterable2 = iterable3;
                for (Object t : iterable2) {
                    Column column = (Column)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)column.getName(), (Object)tableColumn.getName())) continue;
                    v2 = t;
                    break block20;
                }
                v2 = null;
            }
            String string4 = string2;
            Column column = v2;
            if (column != null) {
                void dataColumn;
                iterable2 = column;
                string2 = string4;
                boolean bl = false;
                string = record.get(dataColumn.getName());
                string4 = string2;
            } else {
                string = null;
            }
            iterable3 = string;
            string2 = string4;
            boolean bl = false;
            KType kType = tableColumn.getType().naturalKType();
            if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Boolean.TYPE))) {
                void v5 = stringValue;
                comparable = v5 != null ? Boolean.valueOf(Boolean.parseBoolean((String)v5)) : null;
            } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Long.TYPE))) {
                void v7 = stringValue;
                comparable = v7 != null ? Long.valueOf(Long.parseLong((String)v7)) : null;
            } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(BigDecimal.class))) {
                comparable = stringValue != null ? new BigDecimal((String)stringValue) : null;
            } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Instant.class))) {
                if (stringValue != null) {
                    boolean bl3 = false;
                    comparable = Instant.parse((CharSequence)it);
                } else {
                    comparable = null;
                }
            } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(LocalDate.class))) {
                if (stringValue != null) {
                    boolean bl4 = false;
                    comparable = LocalDate.parse((CharSequence)it);
                } else {
                    comparable = null;
                }
            } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(String.class))) {
                comparable = stringValue;
            } else {
                throw new NotImplementedError("Loading data into a column of type '" + tableColumn.getType() + "' is not yet supported.");
            }
            Pair pair = TuplesKt.to((Object)string2, (Object)comparable);
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map map = destination$iv$iv;
        return new DataRow(map);
    }

    private static final DataRow execute$lambda$4$0$1(Function1 $tmp0, Object p0) {
        return (DataRow)$tmp0.invoke(p0);
    }

    private static final Unit execute$lambda$4$0$2(List $data, DataRow it) {
        Intrinsics.checkNotNull((Object)it);
        $data.add(it);
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$4$0$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a \u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\fH\u0016J\u001a\u0010\u0012\u001a\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\fH\u0016J(\u0010\u0013\u001a\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lrocks/frieler/kraftsql/bq/testing/engine/BigQuerySimulatorConnection$SessionState;", "Lrocks/frieler/kraftsql/testing/engine/EngineState;", "Lrocks/frieler/kraftsql/bq/engine/BigQueryEngine;", "parent", "<init>", "(Lrocks/frieler/kraftsql/testing/engine/EngineState;)V", "containsTable", "", "name", "", "findTable", "Lkotlin/Pair;", "Lrocks/frieler/kraftsql/objects/Table;", "", "Lrocks/frieler/kraftsql/objects/DataRow;", "addTable", "", "table", "removeTable", "writeTable", "data", "", "kraftsql-bigquery-testing"})
    private static final class SessionState
    extends EngineState<BigQueryEngine> {
        @NotNull
        private final EngineState<BigQueryEngine> parent;

        public SessionState(@NotNull EngineState<BigQueryEngine> parent) {
            Intrinsics.checkNotNullParameter(parent, (String)"parent");
            this.parent = parent;
        }

        public boolean containsTable(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return super.containsTable(name) || this.parent.containsTable(name);
        }

        @Nullable
        public Pair<Table<BigQueryEngine, ?>, List<DataRow>> findTable(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Pair pair = super.findTable(name);
            if (pair == null) {
                pair = this.parent.findTable(name);
            }
            return pair;
        }

        public void addTable(@NotNull Table<BigQueryEngine, ?> table) {
            Intrinsics.checkNotNullParameter(table, (String)"table");
            if (table instanceof TemporaryTable) {
                super.addTable(table);
            } else {
                this.parent.addTable(table);
            }
        }

        public void removeTable(@NotNull Table<BigQueryEngine, ?> table) {
            Intrinsics.checkNotNullParameter(table, (String)"table");
            if (table instanceof TemporaryTable) {
                super.removeTable(table);
            } else {
                this.parent.removeTable(table);
            }
        }

        public void writeTable(@NotNull Table<BigQueryEngine, ?> table, @NotNull List<DataRow> data) {
            Intrinsics.checkNotNullParameter(table, (String)"table");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            if (table instanceof TemporaryTable) {
                super.writeTable(table, data);
            } else {
                this.parent.writeTable(table, data);
            }
        }
    }
}

