/*
 * Decompiled with CFR 0.152.
 */
package rocks.frieler.kraftsql.bq.testing.engine;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import rocks.frieler.kraftsql.bq.engine.BigQueryEngine;
import rocks.frieler.kraftsql.bq.expressions.Timestamp;
import rocks.frieler.kraftsql.expressions.Expression;
import rocks.frieler.kraftsql.objects.DataRow;
import rocks.frieler.kraftsql.testing.engine.ExpressionSimulator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J;\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000e2\u0006\u0010\u0007\u001a\u00020\u0004H\u0016R\b\u0012\u0004\u0012\u00020\u00020\u0010j\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010\u00a2\u0006\u0002\u0010\u0012Jm\u0010\u0013\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000e2\u0006\u0010\u0007\u001a\u00020\u0004H\u0016R\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u00150\u0014R\b\u0012\u0004\u0012\u00020\u00020\u0010j\u0016\u0010\u0016\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u00150\u0014j\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lrocks/frieler/kraftsql/bq/testing/engine/TimestampSimulator;", "Lrocks/frieler/kraftsql/testing/engine/ExpressionSimulator;", "Lrocks/frieler/kraftsql/bq/engine/BigQueryEngine;", "Ljava/time/Instant;", "Lrocks/frieler/kraftsql/bq/expressions/Timestamp;", "<init>", "()V", "expression", "Lkotlin/reflect/KClass;", "getExpression", "()Lkotlin/reflect/KClass;", "timestampLiteralPattern", "Ljava/util/regex/Pattern;", "simulateExpression", "Lkotlin/Function1;", "Lrocks/frieler/kraftsql/objects/DataRow;", "Lrocks/frieler/kraftsql/testing/engine/ExpressionSimulator$SubexpressionCallbacks;", "subexpressionCallbacks", "(Lrocks/frieler/kraftsql/testing/engine/ExpressionSimulator$SubexpressionCallbacks;Lrocks/frieler/kraftsql/bq/expressions/Timestamp;)Lkotlin/jvm/functions/Function1;", "simulateAggregation", "", "Lrocks/frieler/kraftsql/expressions/Expression;", "groupExpressions", "(Ljava/util/List;Lrocks/frieler/kraftsql/testing/engine/ExpressionSimulator$SubexpressionCallbacks;Lrocks/frieler/kraftsql/bq/expressions/Timestamp;)Lkotlin/jvm/functions/Function1;", "simulate", "timestamp", "", "kraftsql-bigquery-testing"})
@SourceDebugExtension(value={"SMAP\nTimestampSimulator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimestampSimulator.kt\nrocks/frieler/kraftsql/bq/testing/engine/TimestampSimulator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class TimestampSimulator
implements ExpressionSimulator<BigQueryEngine, Instant, Timestamp> {
    @NotNull
    private final KClass<Timestamp> expression = Reflection.getOrCreateKotlinClass(Timestamp.class);
    @NotNull
    private final Pattern timestampLiteralPattern;

    public TimestampSimulator() {
        String string = "^(?<date>\\d{4}-\\d{1,2}-\\d{1,2})[Tt ](?<time>\\d{1,2}:\\d{1,2}:\\d{1,2}(.\\d{1,6})?)?(?<tz>|[Zz]|[+-]\\d{1,2}(:\\d{2})?| .+/.+)$";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.timestampLiteralPattern = pattern;
    }

    @NotNull
    public KClass<Timestamp> getExpression() {
        return this.expression;
    }

    @NotNull
    public Function1<DataRow, Instant> simulateExpression(@NotNull ExpressionSimulator.SubexpressionCallbacks<BigQueryEngine> subexpressionCallbacks, @NotNull Timestamp expression) {
        Intrinsics.checkNotNullParameter(subexpressionCallbacks, (String)"subexpressionCallbacks");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return arg_0 -> TimestampSimulator.simulateExpression$lambda$0(this, subexpressionCallbacks, expression, arg_0);
    }

    @NotNull
    public Function1<List<DataRow>, Instant> simulateAggregation(@NotNull List<? extends Expression<BigQueryEngine, ?>> groupExpressions, @NotNull ExpressionSimulator.SubexpressionCallbacks<BigQueryEngine> subexpressionCallbacks, @NotNull Timestamp expression) {
        Intrinsics.checkNotNullParameter(groupExpressions, (String)"groupExpressions");
        Intrinsics.checkNotNullParameter(subexpressionCallbacks, (String)"subexpressionCallbacks");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return arg_0 -> TimestampSimulator.simulateAggregation$lambda$0(this, subexpressionCallbacks, groupExpressions, expression, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    private final Instant simulate(String timestamp) {
        Instant instant;
        if (timestamp == null) {
            instant = null;
        } else {
            String string;
            CharSequence charSequence;
            void it;
            Matcher matcher;
            Matcher it2 = matcher = this.timestampLiteralPattern.matcher(timestamp);
            boolean $i$a$-also-TimestampSimulator$simulate$matcher$22 = false;
            if (!it2.matches()) {
                throw new IllegalArgumentException("invalid timestamp format: " + timestamp);
            }
            Matcher matcher2 = matcher;
            String string2 = matcher2.group("date");
            String string3 = matcher2.group("time");
            if (string3 == null) {
                string3 = "00:00:00.000000";
            }
            LocalDateTime localDateTime = LocalDateTime.parse(string2 + "T" + string3);
            String string4 = matcher2.group("tz");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"group(...)");
            String $i$a$-also-TimestampSimulator$simulate$matcher$22 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            LocalDateTime localDateTime2 = localDateTime;
            boolean bl = false;
            LocalDateTime localDateTime3 = localDateTime2;
            CharSequence charSequence2 = (CharSequence)(Intrinsics.areEqual((Object)it, (Object)"z") ? "Z" : it);
            if (charSequence2.length() == 0) {
                localDateTime2 = localDateTime3;
                boolean bl2 = false;
                charSequence = null;
                localDateTime3 = localDateTime2;
            } else {
                charSequence = charSequence2;
            }
            if ((string = (String)charSequence) == null) {
                string = "Z";
            }
            instant = localDateTime3.atZone(ZoneId.of(string)).toInstant();
        }
        return instant;
    }

    private static final Instant simulateExpression$lambda$0(TimestampSimulator this$0, ExpressionSimulator.SubexpressionCallbacks $subexpressionCallbacks, Timestamp $expression, DataRow row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        return this$0.simulate((String)$subexpressionCallbacks.simulateExpression($expression.getStringExpression()).invoke((Object)row));
    }

    private static final Instant simulateAggregation$lambda$0(TimestampSimulator this$0, ExpressionSimulator.SubexpressionCallbacks $subexpressionCallbacks, List $groupExpressions, Timestamp $expression, List rows) {
        Intrinsics.checkNotNullParameter((Object)rows, (String)"rows");
        return this$0.simulate((String)$subexpressionCallbacks.simulateAggregation($groupExpressions, $expression.getStringExpression()).invoke((Object)rows));
    }
}

