/*
 * Decompiled with CFR 0.152.
 */
package rocks.frieler.kraftsql.bq.engine;

import com.google.cloud.Service;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.BigQuerySQLException;
import com.google.cloud.bigquery.ConnectionProperty;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rocks.frieler.kraftsql.bq.dml.Delete;
import rocks.frieler.kraftsql.bq.engine.BigQueryEngine;
import rocks.frieler.kraftsql.bq.engine.BigQueryORMapping;
import rocks.frieler.kraftsql.bq.engine.Type;
import rocks.frieler.kraftsql.bq.engine.Types;
import rocks.frieler.kraftsql.bq.objects.Table;
import rocks.frieler.kraftsql.ddl.CreateTable;
import rocks.frieler.kraftsql.ddl.DropTable;
import rocks.frieler.kraftsql.dml.BeginTransaction;
import rocks.frieler.kraftsql.dml.CommitTransaction;
import rocks.frieler.kraftsql.dml.InsertInto;
import rocks.frieler.kraftsql.dml.RollbackTransaction;
import rocks.frieler.kraftsql.dql.Select;
import rocks.frieler.kraftsql.engine.Connection;
import rocks.frieler.kraftsql.engine.DefaultConnection;
import rocks.frieler.kraftsql.objects.Column;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J:\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\b\b\u0000\u0010\u000b*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u000b0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0010H\u0016J\u0016\u0010\t\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016J\u0016\u0010\t\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016J\u001a\u0010\t\u001a\u00020\u00162\u0010\u0010\u0017\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u0018H\u0016J\u0016\u0010\t\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001aH\u0016J\u0016\u0010\t\u001a\u00020\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0016J\u0016\u0010\t\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001eH\u0016J\u0016\u0010\t\u001a\u00020\u00112\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0016J\u0018\u0010!\u001a\n #*\u0004\u0018\u00010\"0\"*\u0006\u0012\u0002\b\u00030$H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lrocks/frieler/kraftsql/bq/engine/BigQueryConnection;", "Lrocks/frieler/kraftsql/engine/Connection;", "Lrocks/frieler/kraftsql/bq/engine/BigQueryEngine;", "bigquery", "Lcom/google/cloud/bigquery/BigQuery;", "<init>", "(Lcom/google/cloud/bigquery/BigQuery;)V", "activeSession", "", "execute", "", "T", "", "select", "Lrocks/frieler/kraftsql/dql/Select;", "type", "Lkotlin/reflect/KClass;", "", "createTable", "Lrocks/frieler/kraftsql/ddl/CreateTable;", "dropTable", "Lrocks/frieler/kraftsql/ddl/DropTable;", "", "insertInto", "Lrocks/frieler/kraftsql/dml/InsertInto;", "delete", "Lrocks/frieler/kraftsql/dml/Delete;", "beginTransaction", "Lrocks/frieler/kraftsql/dml/BeginTransaction;", "commitTransaction", "Lrocks/frieler/kraftsql/dml/CommitTransaction;", "rollbackTransaction", "Lrocks/frieler/kraftsql/dml/RollbackTransaction;", "getTableId", "Lcom/google/cloud/bigquery/TableId;", "kotlin.jvm.PlatformType", "Lrocks/frieler/kraftsql/bq/objects/Table;", "Default", "kraftsql-bigquery"})
@SourceDebugExtension(value={"SMAP\nBigQueryConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BigQueryConnection.kt\nrocks/frieler/kraftsql/bq/engine/BigQueryConnection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,159:1\n1#2:160\n1563#3:161\n1634#3,2:162\n1285#3,2:164\n1299#3,4:166\n1636#3:170\n1563#3:171\n1634#3,3:172\n126#4:175\n153#4,3:176\n*S KotlinDebug\n*F\n+ 1 BigQueryConnection.kt\nrocks/frieler/kraftsql/bq/engine/BigQueryConnection\n*L\n42#1:161\n42#1:162,2\n43#1:164,2\n43#1:166,4\n42#1:170\n71#1:171\n71#1:172,3\n67#1:175\n67#1:176,3\n*E\n"})
public final class BigQueryConnection
implements Connection<BigQueryEngine> {
    @NotNull
    private final BigQuery bigquery;
    @Nullable
    private String activeSession;

    public BigQueryConnection(@NotNull BigQuery bigquery) {
        Intrinsics.checkNotNullParameter((Object)bigquery, (String)"bigquery");
        this.bigquery = bigquery;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T> List<T> execute(@NotNull Select<BigQueryEngine, T> select, @NotNull KClass<T> type) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        QueryJobConfiguration.Builder builder;
        Intrinsics.checkNotNullParameter(select, (String)"select");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Object $this$execute_u24lambda_u240 = builder = QueryJobConfiguration.newBuilder((String)select.sql()).setUseLegacySql(Boolean.valueOf(false));
        boolean bl = false;
        if (this.activeSession != null) {
            $this$execute_u24lambda_u240.setConnectionProperties(CollectionsKt.listOf((Object)ConnectionProperty.of((String)"session_id", (String)this.activeSession)));
        }
        QueryJobConfiguration jobConfiguration = builder.build();
        TableResult result = this.bigquery.query(jobConfiguration, new BigQuery.JobOption[0]);
        Iterable iterable = result.iterateAll();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"iterateAll(...)");
        $this$execute_u24lambda_u240 = iterable;
        BigQueryORMapping bigQueryORMapping = BigQueryORMapping.INSTANCE;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FieldValueList fieldValueList = (FieldValueList)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Schema schema = result.getSchema();
            Intrinsics.checkNotNull((Object)schema);
            FieldList fieldList = schema.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldList, (String)"getFields(...)");
            Iterable $this$associateWith$iv = (Iterable)fieldList;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void field;
                void fieldValues;
                Field field2 = (Field)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl3 = false;
                FieldValue fieldValue = fieldValues.get(field.getName());
                map.put(t, fieldValue);
            }
            collection.add((Map)result$iv);
        }
        return bigQueryORMapping.deserializeQueryResult((List)destination$iv$iv, type);
    }

    /*
     * WARNING - void declaration
     */
    public void execute(@NotNull CreateTable<BigQueryEngine> createTable) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(createTable, (String)"createTable");
        rocks.frieler.kraftsql.objects.Table table = createTable.getTable();
        Intrinsics.checkNotNull((Object)table, (String)"null cannot be cast to non-null type rocks.frieler.kraftsql.bq.objects.Table<*>");
        Table table2 = (Table)table;
        TableId tableId = table2.getProject() != null ? TableId.of((String)table2.getProject(), (String)table2.getDataset(), (String)table2.getName()) : TableId.of((String)table2.getDataset(), (String)table2.getName());
        Iterable $this$map$iv = table2.getColumns();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void column;
            Column column2 = (Column)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = column.getName();
            rocks.frieler.kraftsql.engine.Type type = column.getType();
            Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type rocks.frieler.kraftsql.bq.engine.Type");
            collection.add(BigQueryConnection.execute$constructField(string, (Type)type));
        }
        Schema schema = Schema.of((Iterable)((List)destination$iv$iv));
        TableInfo tableInfo = TableInfo.of((TableId)tableId, (TableDefinition)((TableDefinition)StandardTableDefinition.of((Schema)schema)));
        this.bigquery.create(tableInfo, new BigQuery.TableOption[0]);
    }

    public void execute(@NotNull DropTable<BigQueryEngine> dropTable) {
        Intrinsics.checkNotNullParameter(dropTable, (String)"dropTable");
        rocks.frieler.kraftsql.objects.Table table = dropTable.getTable();
        Intrinsics.checkNotNull((Object)table, (String)"null cannot be cast to non-null type rocks.frieler.kraftsql.bq.objects.Table<*>");
        boolean didDelete = this.bigquery.delete(this.getTableId((Table)table));
        if (!didDelete && !dropTable.getIfExists()) {
            throw new BigQuerySQLException("Table '" + dropTable.getTable().getQualifiedName() + "' to drop did not exist");
        }
    }

    public int execute(@NotNull InsertInto<BigQueryEngine, ?> insertInto) {
        QueryJobConfiguration.Builder builder;
        Intrinsics.checkNotNullParameter(insertInto, (String)"insertInto");
        QueryJobConfiguration.Builder $this$execute_u24lambda_u245 = builder = QueryJobConfiguration.newBuilder((String)insertInto.sql()).setUseLegacySql(Boolean.valueOf(false));
        boolean bl = false;
        if (this.activeSession != null) {
            $this$execute_u24lambda_u245.setConnectionProperties(CollectionsKt.listOf((Object)ConnectionProperty.of((String)"session_id", (String)this.activeSession)));
        }
        QueryJobConfiguration jobConfiguration = builder.build();
        TableResult result = this.bigquery.query(jobConfiguration, new BigQuery.JobOption[0]);
        return (int)result.getTotalRows();
    }

    public int execute(@NotNull rocks.frieler.kraftsql.dml.Delete<BigQueryEngine> delete) {
        QueryJobConfiguration.Builder $i$a$-require-BigQueryConnection$execute$322;
        Intrinsics.checkNotNullParameter(delete, (String)"delete");
        if (!(delete instanceof Delete)) {
            boolean $i$a$-require-BigQueryConnection$execute$322 = false;
            String $i$a$-require-BigQueryConnection$execute$322 = "BigQuery requires its own Delete implementation.";
            throw new IllegalArgumentException($i$a$-require-BigQueryConnection$execute$322.toString());
        }
        QueryJobConfiguration.Builder $this$execute_u24lambda_u247 = $i$a$-require-BigQueryConnection$execute$322 = QueryJobConfiguration.newBuilder((String)((Delete)delete).sql()).setUseLegacySql(Boolean.valueOf(false));
        boolean bl = false;
        if (this.activeSession != null) {
            $this$execute_u24lambda_u247.setConnectionProperties(CollectionsKt.listOf((Object)ConnectionProperty.of((String)"session_id", (String)this.activeSession)));
        }
        QueryJobConfiguration jobConfiguration = $i$a$-require-BigQueryConnection$execute$322.build();
        TableResult result = this.bigquery.query(jobConfiguration, new BigQuery.JobOption[0]);
        return (int)result.getTotalRows();
    }

    public void execute(@NotNull BeginTransaction<BigQueryEngine> beginTransaction) {
        QueryJobConfiguration.Builder builder;
        Intrinsics.checkNotNullParameter(beginTransaction, (String)"beginTransaction");
        QueryJobConfiguration.Builder $this$execute_u24lambda_u248 = builder = QueryJobConfiguration.newBuilder((String)beginTransaction.sql()).setUseLegacySql(Boolean.valueOf(false));
        boolean bl = false;
        QueryJobConfiguration.Builder builder2 = this.activeSession != null ? $this$execute_u24lambda_u248.setConnectionProperties(CollectionsKt.listOf((Object)ConnectionProperty.of((String)"session_id", (String)this.activeSession))) : $this$execute_u24lambda_u248.setCreateSession(Boolean.valueOf(true));
        QueryJobConfiguration jobConfiguration = builder.build();
        QueryJobConfiguration.Builder it = builder = this.bigquery.query(jobConfiguration, new BigQuery.JobOption[0]);
        boolean bl2 = false;
        String string = this.activeSession;
        if (string == null) {
            string = ((JobStatistics.QueryStatistics)this.bigquery.getJob(it.getJobId(), new BigQuery.JobOption[0]).getStatistics()).getSessionInfo().getSessionId();
        }
        this.activeSession = string;
    }

    public void execute(@NotNull CommitTransaction<BigQueryEngine> commitTransaction) {
        QueryJobConfiguration.Builder builder;
        Intrinsics.checkNotNullParameter(commitTransaction, (String)"commitTransaction");
        QueryJobConfiguration.Builder $this$execute_u24lambda_u2410 = builder = QueryJobConfiguration.newBuilder((String)commitTransaction.sql()).setUseLegacySql(Boolean.valueOf(false));
        boolean bl = false;
        if (this.activeSession != null) {
            $this$execute_u24lambda_u2410.setConnectionProperties(CollectionsKt.listOf((Object)ConnectionProperty.of((String)"session_id", (String)this.activeSession)));
        }
        QueryJobConfiguration jobConfiguration = builder.build();
        this.bigquery.query(jobConfiguration, new BigQuery.JobOption[0]);
    }

    public void execute(@NotNull RollbackTransaction<BigQueryEngine> rollbackTransaction) {
        QueryJobConfiguration.Builder builder;
        Intrinsics.checkNotNullParameter(rollbackTransaction, (String)"rollbackTransaction");
        QueryJobConfiguration.Builder $this$execute_u24lambda_u2411 = builder = QueryJobConfiguration.newBuilder((String)rollbackTransaction.sql()).setUseLegacySql(Boolean.valueOf(false));
        boolean bl = false;
        if (this.activeSession != null) {
            $this$execute_u24lambda_u2411.setConnectionProperties(CollectionsKt.listOf((Object)ConnectionProperty.of((String)"session_id", (String)this.activeSession)));
        }
        QueryJobConfiguration jobConfiguration = builder.build();
        this.bigquery.query(jobConfiguration, new BigQuery.JobOption[0]);
    }

    private final TableId getTableId(Table<?> $this$getTableId) {
        return $this$getTableId.getProject() != null ? TableId.of((String)$this$getTableId.getProject(), (String)$this$getTableId.getDataset(), (String)$this$getTableId.getName()) : TableId.of((String)$this$getTableId.getDataset(), (String)$this$getTableId.getName());
    }

    /*
     * WARNING - void declaration
     */
    private static final Field execute$constructField(String name, Type type) {
        Field field;
        Type type2 = type;
        if (type2 instanceof Types.ARRAY) {
            Field field2 = Field.newBuilder((String)name, (StandardSQLTypeName)((Types.ARRAY)type).getContentType().getName(), (Field[])new Field[0]).setMode(Field.Mode.REPEATED).build();
            Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"build(...)");
            field = field2;
        } else if (type2 instanceof Types.STRUCT) {
            Collection<Field> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map<String, Type> map = ((Types.STRUCT)type).getFields();
            StandardSQLTypeName standardSQLTypeName = type.getName();
            String string = name;
            boolean $i$f$map = false;
            void var6_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl = false;
                String subfieldName = (String)entry.getKey();
                Type subfieldType = (Type)entry.getValue();
                collection.add(BigQueryConnection.execute$constructField(subfieldName, subfieldType));
            }
            collection = (List)destination$iv$iv;
            Field field3 = Field.newBuilder((String)string, (StandardSQLTypeName)standardSQLTypeName, (FieldList)FieldList.of((Iterable)collection)).build();
            Intrinsics.checkNotNullExpressionValue((Object)field3, (String)"build(...)");
            field = field3;
        } else {
            Field field4 = Field.of((String)name, (StandardSQLTypeName)type.getName(), (Field[])new Field[0]);
            field = field4;
            Intrinsics.checkNotNullExpressionValue((Object)field4, (String)"of(...)");
        }
        return field;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lrocks/frieler/kraftsql/bq/engine/BigQueryConnection$Default;", "Lrocks/frieler/kraftsql/engine/DefaultConnection;", "Lrocks/frieler/kraftsql/bq/engine/BigQueryEngine;", "<init>", "()V", "instantiate", "Lrocks/frieler/kraftsql/engine/Connection;", "kraftsql-bigquery"})
    @SourceDebugExtension(value={"SMAP\nBigQueryConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BigQueryConnection.kt\nrocks/frieler/kraftsql/bq/engine/BigQueryConnection$Default\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
    public static final class Default
    extends DefaultConnection<BigQueryEngine> {
        @NotNull
        public static final Default INSTANCE = new Default();

        private Default() {
        }

        @NotNull
        protected Connection<BigQueryEngine> instantiate() {
            BigQueryOptions.Builder builder;
            BigQueryOptions.Builder $this$instantiate_u24lambda_u241 = builder = BigQueryOptions.newBuilder();
            boolean bl = false;
            String string = System.getenv("KRAFTSQL_BIGQUERY_LOCATION");
            if (string != null) {
                String string2;
                String it = string2 = string;
                boolean bl2 = false;
                $this$instantiate_u24lambda_u241.setLocation(it);
            }
            BigQueryOptions bigQueryOptions = builder.build();
            Service service = bigQueryOptions.getService();
            Intrinsics.checkNotNullExpressionValue((Object)service, (String)"getService(...)");
            return new BigQueryConnection((BigQuery)service);
        }
    }
}

