/*
 * Decompiled with CFR 0.152.
 */
package rocks.frieler.kraftsql.bq.engine.api;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQuerySQLException;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rocks.frieler.kraftsql.bq.dml.Delete;
import rocks.frieler.kraftsql.bq.dml.LoadData;
import rocks.frieler.kraftsql.bq.engine.BigQueryConnection;
import rocks.frieler.kraftsql.bq.engine.BigQueryEngine;
import rocks.frieler.kraftsql.bq.engine.BigQueryORMapping;
import rocks.frieler.kraftsql.bq.engine.Type;
import rocks.frieler.kraftsql.bq.engine.Types;
import rocks.frieler.kraftsql.bq.engine.api.SessionHandler;
import rocks.frieler.kraftsql.bq.objects.Table;
import rocks.frieler.kraftsql.bq.objects.TemporaryTable;
import rocks.frieler.kraftsql.ddl.CreateTable;
import rocks.frieler.kraftsql.ddl.DropTable;
import rocks.frieler.kraftsql.dml.BeginTransaction;
import rocks.frieler.kraftsql.dml.CommitTransaction;
import rocks.frieler.kraftsql.dml.InsertInto;
import rocks.frieler.kraftsql.dml.RollbackTransaction;
import rocks.frieler.kraftsql.dql.Select;
import rocks.frieler.kraftsql.objects.Column;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\b\b\u0000\u0010\b*\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u0002H\b0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\b0\u000eH\u0016J\u0016\u0010\u0006\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011H\u0016J\u0016\u0010\u0006\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0016J\u001a\u0010\u0006\u001a\u00020\u00142\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\f\u0012\u0002\b\u00030\u0016H\u0016J\u0016\u0010\u0006\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0018H\u0016J\u0010\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u0006\u001a\u00020\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u001cH\u0016J\u0016\u0010\u0006\u001a\u00020\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001eH\u0016J\u0016\u0010\u0006\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0 H\u0016J\u001a\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\n )*\u0004\u0018\u00010(0(*\u0006\u0012\u0002\b\u00030*H\u0002J\u0010\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020&H\u0016J \u0010/\u001a\u00020$*\u00020$2\b\u0010+\u001a\u0004\u0018\u00010,2\b\b\u0002\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lrocks/frieler/kraftsql/bq/engine/api/ApiClientBigQueryConnection;", "Lrocks/frieler/kraftsql/bq/engine/BigQueryConnection;", "bigquery", "Lcom/google/cloud/bigquery/BigQuery;", "<init>", "(Lcom/google/cloud/bigquery/BigQuery;)V", "execute", "", "T", "", "select", "Lrocks/frieler/kraftsql/dql/Select;", "Lrocks/frieler/kraftsql/bq/engine/BigQueryEngine;", "type", "Lkotlin/reflect/KClass;", "", "createTable", "Lrocks/frieler/kraftsql/ddl/CreateTable;", "dropTable", "Lrocks/frieler/kraftsql/ddl/DropTable;", "", "insertInto", "Lrocks/frieler/kraftsql/dml/InsertInto;", "delete", "Lrocks/frieler/kraftsql/dml/Delete;", "loadData", "Lrocks/frieler/kraftsql/bq/dml/LoadData;", "beginTransaction", "Lrocks/frieler/kraftsql/dml/BeginTransaction;", "commitTransaction", "Lrocks/frieler/kraftsql/dml/CommitTransaction;", "rollbackTransaction", "Lrocks/frieler/kraftsql/dml/RollbackTransaction;", "executeQuery", "Lcom/google/cloud/bigquery/TableResult;", "queryJobConfig", "Lcom/google/cloud/bigquery/QueryJobConfiguration$Builder;", "requireSession", "", "getTableId", "Lcom/google/cloud/bigquery/TableId;", "kotlin.jvm.PlatformType", "Lrocks/frieler/kraftsql/bq/objects/Table;", "sessionHandler", "Lrocks/frieler/kraftsql/bq/engine/api/SessionHandler;", "setSessionMode", "sessionMode", "configureSession", "kraftsql-bigquery"})
@SourceDebugExtension(value={"SMAP\nApiClientBigQueryConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiClientBigQueryConnection.kt\nrocks/frieler/kraftsql/bq/engine/api/ApiClientBigQueryConnection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1563#2:163\n1634#2,2:164\n1285#2,2:166\n1299#2,4:168\n1636#2:172\n1563#2:173\n1634#2,3:174\n1563#2:178\n1634#2,3:179\n1#3:177\n*S KotlinDebug\n*F\n+ 1 ApiClientBigQueryConnection.kt\nrocks/frieler/kraftsql/bq/engine/api/ApiClientBigQueryConnection\n*L\n45#1:163\n45#1:164,2\n46#1:166,2\n46#1:168,4\n45#1:172\n80#1:173\n80#1:174,3\n73#1:178\n73#1:179,3\n*E\n"})
public final class ApiClientBigQueryConnection
implements BigQueryConnection {
    @NotNull
    private final BigQuery bigquery;
    @Nullable
    private SessionHandler sessionHandler;

    public ApiClientBigQueryConnection(@NotNull BigQuery bigquery) {
        Intrinsics.checkNotNullParameter((Object)bigquery, (String)"bigquery");
        this.bigquery = bigquery;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T> List<T> execute(@NotNull Select<BigQueryEngine, T> select, @NotNull KClass<T> type) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(select, (String)"select");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        QueryJobConfiguration.Builder builder = QueryJobConfiguration.newBuilder((String)select.sql());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
        TableResult result = ApiClientBigQueryConnection.executeQuery$default(this, builder, false, 2, null);
        Iterable iterable = result.iterateAll();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"iterateAll(...)");
        Iterable iterable2 = iterable;
        BigQueryORMapping bigQueryORMapping = BigQueryORMapping.INSTANCE;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$associateWithTo$iv$iv;
            FieldValueList fieldValueList = (FieldValueList)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Schema schema = result.getSchema();
            Intrinsics.checkNotNull((Object)schema);
            FieldList fieldList = schema.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldList, (String)"getFields(...)");
            Iterable $this$associateWith$iv = (Iterable)fieldList;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable iterable3 = $this$associateWith$iv;
            Map destination$iv$iv2 = result$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void field;
                void fieldValues;
                Field field2 = (Field)element$iv$iv;
                Object t = element$iv$iv;
                Map map = destination$iv$iv2;
                boolean bl2 = false;
                FieldValue fieldValue = fieldValues.get(field.getName());
                map.put(t, fieldValue);
            }
            collection.add(destination$iv$iv2);
        }
        return bigQueryORMapping.deserializeQueryResult((List)destination$iv$iv, type);
    }

    /*
     * WARNING - void declaration
     */
    public void execute(@NotNull CreateTable<BigQueryEngine> createTable) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(createTable, (String)"createTable");
        if (createTable.getTable() instanceof TemporaryTable) {
            throw new UnsupportedOperationException("The BigQuery API does not support creation of temporary tables.");
        }
        rocks.frieler.kraftsql.objects.Table table = createTable.getTable();
        Intrinsics.checkNotNull((Object)table, (String)"null cannot be cast to non-null type rocks.frieler.kraftsql.bq.objects.Table<*>");
        Table table2 = (Table)table;
        TableId tableId = table2.getProject() != null ? TableId.of((String)table2.getProject(), (String)table2.getDataset(), (String)table2.getName()) : TableId.of((String)table2.getDataset(), (String)table2.getName());
        Iterable $this$map$iv = table2.getColumns();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void column;
            Column column2 = (Column)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ApiClientBigQueryConnection.execute$constructField((Column<BigQueryEngine>)column));
        }
        Schema schema = Schema.of((Iterable)((List)destination$iv$iv));
        TableInfo tableInfo = TableInfo.of((TableId)tableId, (TableDefinition)((TableDefinition)StandardTableDefinition.of((Schema)schema)));
        this.bigquery.create(tableInfo, new BigQuery.TableOption[0]);
    }

    public void execute(@NotNull DropTable<BigQueryEngine> dropTable) {
        Intrinsics.checkNotNullParameter(dropTable, (String)"dropTable");
        if (dropTable.getTable() instanceof TemporaryTable) {
            throw new UnsupportedOperationException("The BigQuery API does not support dropping temporary tables.");
        }
        rocks.frieler.kraftsql.objects.Table table = dropTable.getTable();
        Intrinsics.checkNotNull((Object)table, (String)"null cannot be cast to non-null type rocks.frieler.kraftsql.bq.objects.Table<*>");
        boolean didDelete = this.bigquery.delete(this.getTableId((Table)table));
        if (!didDelete && !dropTable.getIfExists()) {
            throw new BigQuerySQLException("Table '" + dropTable.getTable().getQualifiedName() + "' to drop did not exist");
        }
    }

    public int execute(@NotNull InsertInto<BigQueryEngine, ?> insertInto) {
        Intrinsics.checkNotNullParameter(insertInto, (String)"insertInto");
        QueryJobConfiguration.Builder builder = QueryJobConfiguration.newBuilder((String)insertInto.sql());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
        TableResult result = ApiClientBigQueryConnection.executeQuery$default(this, builder, false, 2, null);
        return (int)result.getTotalRows();
    }

    public int execute(@NotNull rocks.frieler.kraftsql.dml.Delete<BigQueryEngine> delete) {
        Intrinsics.checkNotNullParameter(delete, (String)"delete");
        if (!(delete instanceof Delete)) {
            boolean bl = false;
            String string = "BigQuery requires its own Delete implementation.";
            throw new IllegalArgumentException(string.toString());
        }
        QueryJobConfiguration.Builder builder = QueryJobConfiguration.newBuilder((String)((Delete)delete).sql());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
        TableResult result = ApiClientBigQueryConnection.executeQuery$default(this, builder, false, 2, null);
        return (int)result.getTotalRows();
    }

    @Override
    public void execute(@NotNull LoadData loadData) {
        Intrinsics.checkNotNullParameter((Object)loadData, (String)"loadData");
        QueryJobConfiguration.Builder builder = QueryJobConfiguration.newBuilder((String)loadData.sql());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
        this.executeQuery(builder, loadData.getTable() instanceof TemporaryTable);
    }

    public void execute(@NotNull BeginTransaction<BigQueryEngine> beginTransaction) {
        Intrinsics.checkNotNullParameter(beginTransaction, (String)"beginTransaction");
        QueryJobConfiguration.Builder builder = QueryJobConfiguration.newBuilder((String)beginTransaction.sql());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
        this.executeQuery(builder, true);
    }

    public void execute(@NotNull CommitTransaction<BigQueryEngine> commitTransaction) {
        Intrinsics.checkNotNullParameter(commitTransaction, (String)"commitTransaction");
        QueryJobConfiguration.Builder builder = QueryJobConfiguration.newBuilder((String)commitTransaction.sql());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
        this.executeQuery(builder, true);
    }

    public void execute(@NotNull RollbackTransaction<BigQueryEngine> rollbackTransaction) {
        Intrinsics.checkNotNullParameter(rollbackTransaction, (String)"rollbackTransaction");
        QueryJobConfiguration.Builder builder = QueryJobConfiguration.newBuilder((String)rollbackTransaction.sql());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
        this.executeQuery(builder, true);
    }

    private final TableResult executeQuery(QueryJobConfiguration.Builder queryJobConfig, boolean requireSession) {
        TableResult tableResult;
        QueryJobConfiguration.Builder builder = queryJobConfig.setUseLegacySql(Boolean.valueOf(false));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setUseLegacySql(...)");
        TableResult result = tableResult = this.bigquery.query(this.configureSession(builder, this.sessionHandler, requireSession).build(), new BigQuery.JobOption[0]);
        boolean bl = false;
        SessionHandler sessionHandler = this.sessionHandler;
        if (sessionHandler != null) {
            Intrinsics.checkNotNull((Object)result);
            sessionHandler.memorizeSession(result, this.bigquery);
        }
        TableResult tableResult2 = tableResult;
        Intrinsics.checkNotNullExpressionValue((Object)tableResult2, (String)"also(...)");
        return tableResult2;
    }

    static /* synthetic */ TableResult executeQuery$default(ApiClientBigQueryConnection apiClientBigQueryConnection, QueryJobConfiguration.Builder builder, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return apiClientBigQueryConnection.executeQuery(builder, bl);
    }

    private final TableId getTableId(Table<?> $this$getTableId) {
        return $this$getTableId.getProject() != null ? TableId.of((String)$this$getTableId.getProject(), (String)$this$getTableId.getDataset(), (String)$this$getTableId.getName()) : TableId.of((String)$this$getTableId.getDataset(), (String)$this$getTableId.getName());
    }

    @Override
    public void setSessionMode(boolean sessionMode) {
        if (sessionMode) {
            SessionHandler sessionHandler = this.sessionHandler;
            if (sessionHandler == null) {
                sessionHandler = new SessionHandler();
            }
            this.sessionHandler = sessionHandler;
        } else {
            SessionHandler sessionHandler = this.sessionHandler;
            if (sessionHandler != null) {
                SessionHandler.abortSession$default(sessionHandler, this.bigquery, false, 2, null);
            }
            this.sessionHandler = null;
        }
    }

    private final QueryJobConfiguration.Builder configureSession(QueryJobConfiguration.Builder $this$configureSession, SessionHandler sessionHandler, boolean requireSession) {
        if (sessionHandler != null) {
            SessionHandler.configureSession$default(sessionHandler, $this$configureSession, false, 2, null);
        } else if (requireSession) {
            throw new IllegalStateException("Statement would require a session, but session mode is turned off.");
        }
        return $this$configureSession;
    }

    static /* synthetic */ QueryJobConfiguration.Builder configureSession$default(ApiClientBigQueryConnection apiClientBigQueryConnection, QueryJobConfiguration.Builder builder, SessionHandler sessionHandler, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return apiClientBigQueryConnection.configureSession(builder, sessionHandler, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final Field execute$constructField(Column<BigQueryEngine> column) {
        Field field;
        rocks.frieler.kraftsql.engine.Type type = column.getType();
        Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type rocks.frieler.kraftsql.bq.engine.Type<*>");
        Type type2 = (Type)type;
        if (type2 instanceof Types.ARRAY) {
            if (!(!column.getNullable())) {
                boolean $i$a$-require-ApiClientBigQueryConnection$execute$constructField$22 = false;
                String $i$a$-require-ApiClientBigQueryConnection$execute$constructField$22 = "Array fields must not be nullable.";
                throw new IllegalArgumentException($i$a$-require-ApiClientBigQueryConnection$execute$constructField$22.toString());
            }
            Field field2 = Field.newBuilder((String)column.getName(), (StandardSQLTypeName)((Types.ARRAY)type2).getContentType().getName(), (Field[])new Field[0]).setMode(Field.Mode.REPEATED).build();
            Intrinsics.checkNotNull((Object)field2);
            field = field2;
        } else if (type2 instanceof Types.STRUCT) {
            Collection<Field> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((Types.STRUCT)type2).getFields();
            StandardSQLTypeName standardSQLTypeName = ((Types.STRUCT)type2).getName();
            String string = column.getName();
            boolean $i$f$map = false;
            void var5_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void subfield;
                Column column2 = (Column)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ApiClientBigQueryConnection.execute$constructField((Column<BigQueryEngine>)subfield));
            }
            collection = (List)destination$iv$iv;
            Field field3 = Field.newBuilder((String)string, (StandardSQLTypeName)standardSQLTypeName, (FieldList)FieldList.of((Iterable)collection)).build();
            Intrinsics.checkNotNullExpressionValue((Object)field3, (String)"build(...)");
            field = field3;
        } else {
            Field field4 = Field.newBuilder((String)column.getName(), (StandardSQLTypeName)type2.getName(), (Field[])new Field[0]).setMode(column.getNullable() ? Field.Mode.NULLABLE : Field.Mode.REQUIRED).build();
            field = field4;
            Intrinsics.checkNotNullExpressionValue((Object)field4, (String)"build(...)");
        }
        return field;
    }
}

