/*
 * Decompiled with CFR 0.152.
 */
package rocks.frieler.kraftsql.bq.engine.api;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.ConnectionProperty;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.TableResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rocks.frieler.kraftsql.bq.engine.api.JobConfigurationsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u000fR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lrocks/frieler/kraftsql/bq/engine/api/SessionHandler;", "", "<init>", "()V", "activeSession", "", "getActiveSession", "()Ljava/lang/String;", "setActiveSession", "(Ljava/lang/String;)V", "configureSession", "", "jobConfig", "Lcom/google/cloud/bigquery/QueryJobConfiguration$Builder;", "ensureSession", "", "memorizeSession", "result", "Lcom/google/cloud/bigquery/TableResult;", "bigquery", "Lcom/google/cloud/bigquery/BigQuery;", "abortSession", "force", "kraftsql-bigquery"})
public final class SessionHandler {
    @Nullable
    private String activeSession;

    @Nullable
    public final String getActiveSession() {
        return this.activeSession;
    }

    public final void setActiveSession(@Nullable String string) {
        this.activeSession = string;
    }

    public final void configureSession(@NotNull QueryJobConfiguration.Builder jobConfig, boolean ensureSession) {
        Intrinsics.checkNotNullParameter((Object)jobConfig, (String)"jobConfig");
        if (this.activeSession != null) {
            ConnectionProperty connectionProperty = ConnectionProperty.of((String)"session_id", (String)this.activeSession);
            Intrinsics.checkNotNullExpressionValue((Object)connectionProperty, (String)"of(...)");
            JobConfigurationsKt.setConnectionProperty(jobConfig, connectionProperty);
        } else if (ensureSession) {
            jobConfig.setCreateSession(Boolean.valueOf(true));
        }
    }

    public static /* synthetic */ void configureSession$default(SessionHandler sessionHandler, QueryJobConfiguration.Builder builder, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        sessionHandler.configureSession(builder, bl);
    }

    public final void memorizeSession(@NotNull TableResult result, @NotNull BigQuery bigquery) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)bigquery, (String)"bigquery");
        this.activeSession = ((JobStatistics.QueryStatistics)bigquery.getJob(result.getJobId(), new BigQuery.JobOption[0]).getStatistics()).getSessionInfo().getSessionId();
    }

    public final void abortSession(@NotNull BigQuery bigquery, boolean force) {
        Intrinsics.checkNotNullParameter((Object)bigquery, (String)"bigquery");
        if (this.activeSession != null) {
            bigquery.query(QueryJobConfiguration.newBuilder((String)("CALL BQ.ABORT_SESSION('" + this.activeSession + "')")).build(), new BigQuery.JobOption[0]);
            this.activeSession = null;
        } else if (force) {
            throw new IllegalStateException("no active session to abort.");
        }
    }

    public static /* synthetic */ void abortSession$default(SessionHandler sessionHandler, BigQuery bigQuery, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        sessionHandler.abortSession(bigQuery, bl);
    }
}

