/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 */

package rocks.imsofa.ai.puppychatter;

/**
 *
 * @author lendle
 */
public interface PuppyChatter<T extends PromptParameters, S extends Response> {
/**
     * initialize a chat session with 
     * a default model and
     * return a session id to be used
     * in further chats
     * @return 
     */
    public String createSession();
    /**
     * a asynchronous version of bark
     * @param sessionId
     * @param prompt
     * @param parameters
     * @param barkCallback
     * @throws BarkException 
     */
    public void bark(String sessionId, String prompt, T parameters, BarkCallback barkCallback) throws BarkException;
    public S bark(String sessionId, String prompt, T parameters) throws BarkException;
    public S bark(String sessionId, String prompt, T parameters, ResponseVerifier verifier) throws BarkException;
    /**
     * async bark with default PromptParameters, implementation should automatically provide
     * @param sessionId
     * @param prompt
     * @param barkCallback
     * @throws BarkException 
     */
    public void bark(String sessionId, String prompt, BarkCallback barkCallback) throws BarkException;
    /**
     * bark with default PromptParameters, implementation should automatically provide
     * @param sessionId
     * @param prompt
     * @return
     * @throws BarkException 
     */
    public S bark(String sessionId, String prompt) throws BarkException;
    /**
     * bark with default PromptParameters, implementation should automatically provide
     * @param sessionId
     * @param prompt
     * @param verifier
     * @return
     * @throws BarkException 
     */
    public S bark(String sessionId, String prompt,ResponseVerifier verifier) throws BarkException;
    
    public void closeSession(String sessionId);
}
