/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package rocks.imsofa.ai.puppychatter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.slf4j.LoggerFactory;

/**
 * the response of a prompt
 *
 * @author USER
 */
public class Response {

    /**
     * indicate whether this is an error or not
     */
    protected boolean error = false;
    /**
     * contain error message if error=true
     */
    protected String errorMessage = null;
    /**
     * the response message if error=false
     */
    protected String message = null;

    public boolean isError() {
        return error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getMessage(String contentType) {
        String message = this.message.trim();
        if (message.startsWith("```html") || message.startsWith("```json")) {
            message = message.substring(7);
            int index = message.lastIndexOf("```");
            message = message.substring(0, index);
        }
        if (message.startsWith("```\r\nhtml") || message.startsWith("```\r\njson")) {
            message = message.substring(8);
            int index = message.lastIndexOf("```");
            message = message.substring(0, index);
        }

        return message;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * return messages only from the specified block type e.g., by given type
     * json only return messages in ```json ``` blocks
     *
     * @param type
     * @return
     */
    public List<String> getMessageOfBlockType(String type) {
        List<String> ret = new ArrayList<>();
        boolean match = false;
        if (message == null) {
            return ret;
        } else {
            try {
                BufferedReader reader = new BufferedReader(new StringReader(message));
                String line = reader.readLine();
                StringBuilder currentBlock = new StringBuilder();
                while (line != null) {
                    if (match) {
                        if (line.trim().equals("```")) {
                            match = false;
                            ret.add(currentBlock.toString());
                            currentBlock = new StringBuilder();
                        } else {
                            if (currentBlock.length() != 0) {
                                currentBlock.append("\r\n");
                            }
                            currentBlock.append(line);
                        }
                    } else {
                        if(line.trim().equals("```"+type)){
                            match=true;
                        }
                    }
                    line = reader.readLine();
                }
                return ret;
            } catch (IOException ex) {
                LoggerFactory.getLogger(this.getClass()).error(ex.getMessage(), ex);
                return ret;
            }
        }
    }
}
