/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package rocks.imsofa.ai.puppychatter.cache;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.LoggerFactory;
import rocks.imsofa.ai.puppychatter.Conversation;

/**
 *
 * @author lendle
 */
public class FileSystemCacheService implements CacheService {
    private File rootFolder = new File(".");

    public FileSystemCacheService(File rootFolder) {
        this.rootFolder=rootFolder;
    }

    public FileSystemCacheService() {
    }

    @Override
    public Conversation getCachedReply(List<Conversation> conversations) throws Exception{
        List<Conversation> bound=this.sync2BoundConversations(conversations);
//        System.out.println("bound.size="+bound.size());
        for(Conversation c : bound){
            FileCachedConversation fc=(FileCachedConversation) c;
//            System.out.println(fc.getContainerFolder()+":"+fc.getContent());
        }
        
        FileCachedConversation fc=(FileCachedConversation) bound.get(bound.size()-1);
        File targetDir=fc.getContainerFolderFile();
//        for(File subFile : fc.getContainerFolderFile().listFiles()){
//            if(subFile.isDirectory()){
//                targetDir=subFile;
//                break;
//            }
//        }
//        System.out.println("targetDir="+targetDir);
        if(targetDir==null){
            return null;
        }else{
            synchronized (this) {
                File indexFile = new File(targetDir, ".index");
                if(indexFile.exists()==false){
                    return null;
                }
                Gson gson = new Gson();
                Map<String, String> map=gson.fromJson(FileUtils.readFileToString(indexFile, "utf-8"), Map.class);
                String realKey=this.getRealKey(bound);
                String text=map.get(realKey);
//                System.out.println("realKey="+this.getRealKey(bound));
                Conversation ret=gson.fromJson(text, Conversation.class);
                LoggerFactory.getLogger(this.getClass().getName()).info("check cache with realKey="+realKey+"\r\n\tand ret="+text);
//                ret.setContainerFolder(targetDir.getAbsolutePath());
//                System.out.println("return "+ret.getContainerFolder());
                return ret;
            }
        }
    }

    @Override
    public List<Conversation> sync2BoundConversations(List<Conversation> conversations) throws Exception{
//        System.out.println("conversations.size="+conversations.size());
        File currentFolder=this.rootFolder;
        List<Conversation> ret=new ArrayList<>();
        boolean synced=true;
        for(Conversation c : conversations){
            if(!(c instanceof FileCachedConversation)){
                synced=false;
                break;
            }
        }
        if(synced){
            return conversations;
        }
        for(Conversation c : conversations){
            if(c instanceof FileCachedConversation){
//                System.out.println("fc "+c.getContent());
                FileCachedConversation fc=(FileCachedConversation) c;
                ret.add(fc);
                currentFolder=fc.getContainerFolderFile();
            }else{
//                System.out.println("c "+c.getContent());
                FileCachedConversation fc=this.save2Folder(c, currentFolder);
                ret.add(fc);
                currentFolder=fc.getContainerFolderFile();
            }
        }
        return ret;
    }
    
    private synchronized FileCachedConversation save2Folder(Conversation originalConversation, File parentContainerFolder) throws IOException {
        String key=getPartialKey(originalConversation.getContent());
//        System.out.println(originalConversation.getContent()+":"+key);
        File containerFolder=new File(parentContainerFolder, key);
        if(containerFolder.exists()==false || containerFolder.isDirectory()==false){
            containerFolder.mkdirs();
        }
        FileCachedConversation fc=new FileCachedConversation(containerFolder.getAbsolutePath());
        fc.setContainerFolder(new File(parentContainerFolder, key).getAbsolutePath());
//        File indexFile = new File(containerFolder, ".index");
//        Map<String, String> map=null;
//        Gson gson = new Gson();
//        String serialized=gson.toJson(originalConversation);
//        if (!indexFile.exists()) {
//            map=new HashMap<>();
//            map.put(key, serialized);
//            FileUtils.write(indexFile, gson.toJson(map), "utf-8");
//        } else {
//            String str = FileUtils.readFileToString(indexFile, "utf-8");
//            map = gson.fromJson(str, Map.class);
//            map.put(key, serialized);
//            FileUtils.write(indexFile, gson.toJson(map), "utf-8");
//        }
        
        fc.setRole(originalConversation.getRole());
        fc.setContent(originalConversation.getContent());
        return fc;
    }
    
    private String getPartialKey(String text){
        if(text.startsWith("model:")){
            //remove the possible model prefix
            int index = text.indexOf(" ");
            text = text.substring(index + 1);
        }
        String reverse=new StringBuilder(text).reverse().toString();
        String base64 = Base64.getEncoder().encodeToString(text.getBytes());
        String base642= Base64.getEncoder().encodeToString(reverse.getBytes());
        String key1 = (base64.length() > 50) ? base64.substring(0, 50) : base64;
        String key2 = (base642.length() > 50) ? base642.substring(0, 50) : base642;
//        return (key1+key2).replace('/', '_').replace('\\', '_').replace(':', '_').replace('?', '_').replace('!', '_');
        return (key1+key2).replaceAll("\\W", "_");
    }

    @Override
    public void cacheReply(List<Conversation> query, Conversation reply) throws Exception {
        List<Conversation> boundQuery=this.sync2BoundConversations(query);
        //get the last conversation
        FileCachedConversation fileCachedConversation=(FileCachedConversation) boundQuery.get(boundQuery.size()-1);
        File folder=fileCachedConversation.getContainerFolderFile();
//        System.out.println("save to folder:"+folder);
        File indexFile = new File(folder, ".index");
        Map<String, String> map=null;
        Gson gson = new Gson();
        String realKey=this.getRealKey(query);
        String serialized=gson.toJson(reply);
        LoggerFactory.getLogger(this.getClass().getName()).info("save to cache inside folder: "+folder+" with realKey="+realKey);
        if (!indexFile.exists()) {
            map=new HashMap<>();
            map.put(realKey, serialized);
            FileUtils.write(indexFile, gson.toJson(map), "utf-8");
        } else {
            String str = FileUtils.readFileToString(indexFile, "utf-8");
            map = gson.fromJson(str, Map.class);
            map.put(realKey, serialized);
            FileUtils.write(indexFile, gson.toJson(map), "utf-8");
        }
    }
    
    public String getRealKey(List<Conversation> query){
        Gson gson = new Gson();
        List<String> allMessages=new ArrayList<>();
        for(Conversation c : query){
            String text=c.getContent();
            if(text.startsWith("model:")){
                //remove the possible model prefix
                int index = text.indexOf(" ");
                text = text.substring(index + 1);
            }
            allMessages.add(text);
        }
        String realKey=gson.toJson(allMessages);
        return realKey;
    }
}
