/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package rocks.imsofa.ai.puppychatter.gemini;

import com.github.kevinsawicki.http.HttpRequest;
import com.google.gson.Gson;
import java.io.File;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.cache.TwoLevelFileCache;

/**
 *
 * @author lendle
 */
public abstract class AbstractGoogleSearchHandler implements GoogleSearchHandler {
    private TwoLevelFileCache queryResultCache=null, linkCache=null;
    public List<String> search(String apiKey, String searchEngineId, String query) throws Exception{
        
        
        File cacheFolder=new File(".cache");
        File googleSearchCache=new File(cacheFolder, ".google");
        File queryResultCacheFolder=new File(googleSearchCache, ".result");
        File linkCacheFolder=new File(googleSearchCache, ".link");
        
        if(queryResultCacheFolder.exists()==false){
            queryResultCacheFolder.mkdirs();
        }
        
        if(linkCacheFolder.exists()==false){
            linkCacheFolder.mkdirs();
        }
        
        queryResultCache=new TwoLevelFileCache(queryResultCacheFolder);
        linkCache=new TwoLevelFileCache(linkCacheFolder);
        
        List<String> ret=new ArrayList<>();
        Map<String, Object> resp=getQueryResult(queryResultCache, apiKey, searchEngineId, query);
        if(resp.containsKey("items")){
            List<String> links=new ArrayList<>();
            List<Map<String, String>> items = (List<Map<String, String>>) resp.get("items");
            for (Map<String, String> item : items) {
                try {
                    String link = item.get("link");
                    if(shouldIncludeLink(link)){
                        links.add(link);
                        String content = getLinkContent(linkCache, link);
                        String summary=summarizePageContent(content);
                        ret.add(summary);
                        
                        if(!shouldGoNextLink(links)){
                            break;
                        }
                    }
                } catch (Exception ex) {
                    Logger.getLogger(GoogleSearchFactSource.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }else{
            throw new Exception("no match in query");
        }
        return ret;
    }
    
    private String getLinkContent(TwoLevelFileCache linkCache, String link) throws Exception{
        String content=linkCache.getFromCache(link);
        if(content!=null){
            return content;
        }else{
            content = HttpRequest.get(link).body();
            linkCache.save2Cache(link, content);
            return content;
        }
    }
    
    private Map<String, Object> getQueryResult(TwoLevelFileCache queryResultCache, String apiKey, String searchEngineId, String query) throws Exception{
        Gson gson=new Gson();
        String queryResultJson=queryResultCache.getFromCache(query);
        if(queryResultJson!=null){
            return gson.fromJson(queryResultJson, Map.class);
        }else{
            HttpRequest request = HttpRequest.get("https://www.googleapis.com/customsearch/v1", true,
                "key", apiKey, "cx", searchEngineId, "q", query);
//            System.out.println("google query="+query);
            String response = request.body();
            Map<String, Object> resp = gson.fromJson(response, Map.class);
            if(resp.containsKey("items")){
                //save to cache
                queryResultCache.save2Cache(query, response);
            }
            return resp;
        }
    } 
    
    @Override
    public String constructQueryForConversation(String conversationBaseQuery, List<Conversation> messages) throws Exception {
        String conversation = messages.get(messages.size() - 1).getContent();
        List<String> keywords = (KeywordExtractor.getKeywords(conversation, 2));
        String query = conversationBaseQuery + " \"" + String.join("\" | \"", keywords) + "\"";
        return query;
    }

    public abstract boolean shouldIncludeLink(String link);

    public abstract boolean shouldGoNextLink(List<String> processedLinks);
    
    public abstract String summarizePageContent(String html) throws Exception;

    @Override
    public String constructQueryForSummary(String summaryBaseQuery) throws Exception {
        return summaryBaseQuery;
    }

}
