/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package rocks.imsofa.ai.puppychatter.gemini;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.DriveScopes;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import rocks.imsofa.ai.puppychatter.BarkException;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.gemini.drive.GoogleDriveFileContentGetter;

/**
 * a fact source that connects to google drive
 * to use this class, first, add codenote@api-project-437674419610.iam.gserviceaccount.com
 * as a viewer to the target google drive folder
 * and then pass the id of the folder as a parameter to the
 * constructor
 * @author lendle
 */
public class GoogleDriveFactSource extends PreparedInlinePassages {

    private String folderId;

    public GoogleDriveFactSource(String folderId, String staticSummaryContent) {
        super(true, staticSummaryContent, new ArrayList<>());
        this.folderId = folderId;
    }

    public GoogleDriveFactSource(String folderId) {
        this(folderId, null);
    }

    protected void preparePassages(List<Conversation> messages) throws BarkException {
        super.passages.clear();
        try (InputStream keyInputStream = this.getClass().getClassLoader().getResourceAsStream("rocks/imsofa/ai/puppychatter/api-project-437674419610-aa7964630016.json");) {

            GoogleCredentials credentials = GoogleCredentials.fromStream(keyInputStream)
                    .createScoped(Collections.singleton(DriveScopes.DRIVE));
            JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
            Drive drive = new Drive.Builder(
                    GoogleNetHttpTransport.newTrustedTransport(),
                    JSON_FACTORY,
                    new HttpCredentialsAdapter(credentials))
                    .setApplicationName("API Project")
                    .build();
            Drive.Files.List list = drive.files().list();
            list.setPageSize(10);
            System.out.println(constructKeywordQuery(messages) + " and parents in '" + folderId + "'");
            list.setQ(constructKeywordQuery(messages) + " and parents in '" + folderId + "'");
            list.setFields("nextPageToken, files(id, name, modifiedTime, mimeType, fileExtension, createdTime)");
            String nextPageToken = null;
            FileList fileList = list.execute();
            java.util.List<File> files = fileList.getFiles();
            long totalLength=0;
            for (int i = 0; i < files.size(); i++) {
                File file = files.get(i);
                
                String textContent = null;
                try{
                    textContent=GoogleDriveFileContentGetter.getTextContent(drive, file);
                }catch(Exception e){
                    System.out.println(file.getName());
                    continue;
                }
                if (textContent.length() > 1000) {
                    textContent = Summarizer.getSummary(textContent, 1000);
                }
                super.passages.add(textContent);
                totalLength+=textContent.length();
                if(totalLength>=5000){
                    break;
                }
            }
            nextPageToken = fileList.getNextPageToken();
//            System.out.println("nextPageToken="+nextPageToken);
            list.setPageToken(nextPageToken);
        } catch (Exception e) {
            throw new BarkException(e);
        }
    }

    private String constructKeywordQuery(List<Conversation> messages) throws BarkException {
        String conversation = messages.get(messages.size() - 1).getContent();
        List<String> keywords = (KeywordExtractor.getKeywords(conversation, 5));
        StringBuilder sb = new StringBuilder();
        for (String keyword : keywords) {
            if (!sb.isEmpty()) {
                sb.append(" or ");
            }
            sb.append("fullText contains '" + keyword + "'");
        }
        return "(" + sb.toString() + ")";
    }

    public static void main(String[] args) throws Exception {
        GoogleDriveFactSource factSource = new GoogleDriveFactSource("11GYNFZ6zrKWnqebDbYljrSCC6YxqDR9O");
        System.out.println(factSource.toJsonPayload(List.of(new Conversation("user", "flyer related books"))));
    }
}
