/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package rocks.imsofa.ai.puppychatter.gemini;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.imsofa.ai.puppychatter.BarkException;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.PromptParameters;
import rocks.imsofa.ai.puppychatter.PuppyChatter;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.cache.FileSystemCacheService;
import rocks.imsofa.ai.puppychatter.openrouter.OpenrouterPuppyChatter;

/**
 *
 * a special type of inlinepassages that use a google search to obtain passages
 * a baseQuery can be specified as as the initial query the implementation will
 * use the last conversation to construct additional query terms
 *
 * @author USER
 */
public class GoogleSearchFactSource extends PreparedInlinePassages {

    private String apiKey = null;
    private String searchEngineId = null;
    private String conversationBaseQuery = "";
    private String summaryBaseQuery = "";
    /**
     * this is a limited key which use only free models
     */
    private OpenrouterPuppyChatter puppyChatter = null;
    private GoogleSearchHandler googleSearchHandler = null;

    public GoogleSearchFactSource(String apiKey, String searchEngineId, String conversationBaseQuery, String summaryBaseQuery, GoogleSearchHandler googleSearchHandler) {
        this(false, null,  apiKey, searchEngineId, conversationBaseQuery, summaryBaseQuery, googleSearchHandler);
    }

    public GoogleSearchFactSource(String apiKey, String searchEngineId, String conversationBaseQuery, String summaryBaseQuery) {
        this(false, null, apiKey, searchEngineId, conversationBaseQuery, summaryBaseQuery, null);
        this.googleSearchHandler=new DefaultGoogleSearchHandler(puppyChatter);
    }
    
    public GoogleSearchFactSource(boolean staticSummary, String staticSummaryContent, 
            String apiKey, String searchEngineId, String conversationBaseQuery, String summaryBaseQuery, GoogleSearchHandler googleSearchHandler) {
        this.staticSummary=staticSummary;
        this.staticSummaryContent=staticSummaryContent;
        this.apiKey = apiKey;
        this.searchEngineId = searchEngineId;
        this.conversationBaseQuery = conversationBaseQuery;
        this.summaryBaseQuery = summaryBaseQuery;
        File cacheFolder = new File(".cache");
        if (cacheFolder.exists() == false) {
            cacheFolder.mkdirs();
        }
        puppyChatter = new OpenrouterPuppyChatter("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", new FileSystemCacheService(cacheFolder));
        this.googleSearchHandler=googleSearchHandler;
    }
    
    public GoogleSearchFactSource(boolean staticSummary, String staticSummaryContent, 
            String apiKey, String searchEngineId, String conversationBaseQuery, GoogleSearchHandler googleSearchHandler) {
        this(false, null, apiKey, searchEngineId, conversationBaseQuery, null, googleSearchHandler);
    }
    
    public GoogleSearchFactSource(boolean staticSummary, String staticSummaryContent, 
            String apiKey, String searchEngineId, String conversationBaseQuery) {
        this(false, null, apiKey, searchEngineId, conversationBaseQuery, null, null);
        this.googleSearchHandler=new DefaultGoogleSearchHandler(puppyChatter);
    }


    public static void main(String[] args) throws Exception {
        GoogleSearchFactSource factSource = new GoogleSearchFactSource("", "d69a8e1591ab74e9e", "site:https://imsofa.rocks/urbanmining", "mining");
//        System.out.println(factSource.toJsonPayload(List.of(new Conversation("user", "what is urbanmining"))));
    }

    protected void preparePassages(List<Conversation> messages) throws BarkException {
        try {
            String query = googleSearchHandler.constructQueryForConversation(conversationBaseQuery, messages);
            try {
                List<String> contents = googleSearchHandler.search(apiKey, searchEngineId, query);
                passages.addAll(contents);
//                GoogleSearchTool.search(apiKey, searchEngineId, query, new GoogleSearchTool.GoogleSearchCallback() {
//                    @Override
//                    public void htmlContentReceived(String link, String content, String summary) throws Exception {
//                        passages.add(summary);
//                    }
//                }, googleSearchHandler);
            } catch (Exception e) {
                throw new BarkException(e);
            }
        } catch (Exception ex) {
            Logger.getLogger(GoogleSearchFactSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String getSummary() throws Exception {
        try {
            String query = googleSearchHandler.constructQueryForSummary(summaryBaseQuery);
            StringBuffer ret = new StringBuffer();
            try {
                List<String> contents = googleSearchHandler.search(apiKey, searchEngineId, query);
                for (String content : contents) {
                    if (ret.length() != 0) {
                        ret.append("\r\n");
                    }
                    ret.append(content);
                }

                return ret.toString();
            } catch (Exception e) {
                throw new BarkException(e);
            }
        } catch (Exception ex) {
            Logger.getLogger(GoogleSearchFactSource.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    static class DefaultGoogleSearchHandler extends AbstractGoogleSearchHandler {
        private PuppyChatter puppyChatter=null;
        
        public DefaultGoogleSearchHandler(PuppyChatter puppyChatter){
            this.puppyChatter=puppyChatter;
        }
        @Override
        public boolean shouldIncludeLink(String link) {
            return true;
        }

        @Override
        public String summarizePageContent(String html) throws Exception {
            String sessionId = puppyChatter.createSession();
            String prompt = "model:google/gemma-2-9b-it:free 請從以下的網頁內容，摘要出最重要的內容，並以文字1000字以內表達：\r\n" + html;

            Response puppyResponse = puppyChatter.bark(sessionId, prompt, new PromptParameters("user"));
            puppyChatter.closeSession(sessionId);
            return puppyResponse.getMessage();
        }

        @Override
        public boolean shouldGoNextLink(List<String> processedLinks) {
            return processedLinks.size() < 5;
        }
    }
}
