/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package rocks.imsofa.ai.puppychatter.gemini;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.imsofa.ai.puppychatter.BarkException;
import rocks.imsofa.ai.puppychatter.Conversation;

/**
 *
 * @author lendle
 */
public abstract class PreparedInlinePassages extends InlinePassages{
    
    /**
     * by default, staticSummary=false
     */
    public PreparedInlinePassages() {
        super(false, null, null);
    }
    
    public PreparedInlinePassages(boolean staticSummary) {
        super(staticSummary, null, null);
    }

    public PreparedInlinePassages(List<String> passages) {
        super(false, null, passages);
    }
    
    public PreparedInlinePassages(boolean staticSummary, List<String> passages) {
        super(staticSummary, null, passages);
    }
    
    public PreparedInlinePassages(boolean staticSummary, String staticSummaryContent, List<String> passages) {
        super.staticSummary=staticSummary;
        super.staticSummaryContent=staticSummaryContent;
        super.passages=passages;
    }
    
    @Override
    public Map toJsonPayload(List<Conversation> messages) {
        if (super.passages == null || super.passages.isEmpty()) {
            try {
                this.preparePassages(messages);
                return super.toJsonPayload(null);
            } catch (BarkException ex) {
                Logger.getLogger(GoogleDriveFactSource.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            return super.toJsonPayload(null);
        }
        return null;
    }

    protected abstract void preparePassages(List<Conversation> messages) throws BarkException;
}
