/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package rocks.imsofa.ai.puppychatter.gemini;

import com.github.kevinsawicki.http.HttpRequest;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.imsofa.ai.puppychatter.BarkException;
import rocks.imsofa.ai.puppychatter.Conversation;

/**
 *
 * @author lendle
 */
public class TravilyFactSource extends PreparedInlinePassages {

    private String travilyAPIKey = null;

    public TravilyFactSource(String travilyAPIKey, String staticSummaryContent) {
        super(true, staticSummaryContent, new ArrayList<>());
        this.travilyAPIKey = travilyAPIKey;
    }

    public TravilyFactSource(String travilyAPIKey) {
        this(travilyAPIKey, null);
    }

    protected void preparePassages(List<Conversation> messages) throws BarkException {
        super.passages.clear();
        Gson gson = new Gson();
        String conversation = messages.get(messages.size() - 1).getContent();
        Map request = Map.of(
                "query", conversation,
                "api_key", travilyAPIKey);
        String str = HttpRequest.post("https://api.tavily.com/search").contentType("application/json;charset=utf-8").send(gson.toJson(request)).body();
        Map result = gson.fromJson(str, Map.class);
        List list = (List) result.get("results");
        int wordCount = 0;
        for (int i = 0; i < list.size(); i++) {
            Map queryReturn = (Map) list.get(i);
            String content = (String) queryReturn.get("content");
            int nextWordCount = wordCount + content.length();
            if (nextWordCount > 6000) {
                if (wordCount > 3000) {
                    break;
                } else {
                    content = Summarizer.getSummary(content, 1000);
                }
            }
            super.passages.add(content);
        }
    }

    public static void main(String[] args) throws Exception {
        TravilyFactSource factSource=new TravilyFactSource("...");
        System.out.println(factSource.toJsonPayload(List.of(new Conversation("user", "請比較java和python"))));
    }
}
