/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

public class Response {
    protected boolean error = false;
    protected String errorMessage = null;
    protected String message = null;

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getMessage(String contentType) {
        int index;
        String message = this.message.trim();
        if (message.startsWith("```html") || message.startsWith("```json")) {
            message = message.substring(7);
            index = message.lastIndexOf("```");
            message = message.substring(0, index);
        }
        if (message.startsWith("```\r\nhtml") || message.startsWith("```\r\njson")) {
            message = message.substring(8);
            index = message.lastIndexOf("```");
            message = message.substring(0, index);
        }
        return message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<String> getMessageOfBlockType(String type) {
        ArrayList<String> ret = new ArrayList<String>();
        boolean match = false;
        if (this.message == null) {
            return ret;
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(this.message));
            String line = reader.readLine();
            StringBuilder currentBlock = new StringBuilder();
            while (line != null) {
                if (match) {
                    if (line.trim().equals("```")) {
                        match = false;
                        ret.add(currentBlock.toString());
                        currentBlock = new StringBuilder();
                    } else {
                        if (currentBlock.length() != 0) {
                            currentBlock.append("\r\n");
                        }
                        currentBlock.append(line);
                    }
                } else if (line.trim().equals("```" + type)) {
                    match = true;
                }
                line = reader.readLine();
            }
            return ret;
        }
        catch (IOException ex) {
            LoggerFactory.getLogger(this.getClass()).error(ex.getMessage(), (Throwable)ex);
            return ret;
        }
    }
}

