/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.openrouter;

import com.github.kevinsawicki.http.HttpRequest;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.jxpath.JXPathContext;
import org.slf4j.LoggerFactory;
import rocks.imsofa.ai.puppychatter.AbstractPuppyChatter;
import rocks.imsofa.ai.puppychatter.BarkCallback;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.PromptParameters;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.cache.CacheService;

public class OpenrouterPuppyChatter
extends AbstractPuppyChatter<PromptParameters, Response> {
    private String apiKey = null;
    private String defaultModel = "meta-llama/llama-3.3-70b-instruct:free";

    public OpenrouterPuppyChatter(String apiKey, String defaultModel, CacheService cacheService) {
        this.apiKey = apiKey;
        this.defaultModel = defaultModel;
        this.cacheService = cacheService;
    }

    public OpenrouterPuppyChatter(String apiKey) {
        this(apiKey, "meta-llama/llama-3.3-70b-instruct:free", null);
    }

    public OpenrouterPuppyChatter(String apiKey, CacheService cacheService) {
        this(apiKey, "meta-llama/llama-3.3-70b-instruct:free", cacheService);
    }

    @Override
    protected void _bark(String sessionId, List<Conversation> messages, PromptParameters parameters, BarkCallback callback) throws Exception {
        Gson gson = new Gson();
        HttpRequest request = this.constructHttpRequest(messages, true);
        Response response = new Response();
        response.setMessage("");
        String ret = null;
        try (InputStream inputStream = request.stream();){
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            String line = reader.readLine();
            while (line != null) {
                if (!((line = line.trim()).isEmpty() || "[DONE]".equals(line = line.substring(line.indexOf(" ") + 1)) || "OPENROUTER PROCESSING".equals(line))) {
                    Response chunk = new Response();
                    Map result = (Map)gson.fromJson(line, Map.class);
                    JXPathContext context = JXPathContext.newContext((Object)result);
                    String output = (String)context.getValue("choices[1]/delta/content");
                    String finishReason = (String)context.getValue("choices[1]/finish_reason");
                    chunk.setMessage(output);
                    response.setMessage(response.getMessage() + output);
                    callback.responseChunkReceived(chunk);
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error(e.getMessage() + "\r\n" + ret);
            response.setError(true);
            response.setErrorMessage(e.getMessage());
        }
        callback.finalVerify(response);
    }

    @Override
    protected Response _bark(String sessionId, List<Conversation> messages, PromptParameters parameters) throws Exception {
        Gson gson = new Gson();
        HttpRequest request = this.constructHttpRequest(messages, false);
        Response response = new Response();
        String ret = null;
        try {
            ret = request.body();
            LoggerFactory.getLogger(this.getClass()).debug("original returned message: " + ret);
            Map result = (Map)gson.fromJson(ret, Map.class);
            JXPathContext context = JXPathContext.newContext((Object)result);
            String output = (String)context.getValue("choices[1]/message/content");
            String finishReason = (String)context.getValue("choices[1]/finish_reason");
            Map message = (Map)context.getValue("choices[1]/message");
            response.setError(false);
            response.setErrorMessage(null);
            response.setMessage(output);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error(e.getMessage() + "\r\n" + ret);
            response.setError(true);
            response.setErrorMessage(e.getMessage());
        }
        return response;
    }

    private HttpRequest constructHttpRequest(List<Conversation> messages, boolean stream) throws Exception {
        Gson gson = new Gson();
        Conversation lastConversation = messages.get(messages.size() - 1);
        String prompt = lastConversation.getContent().trim();
        String model = this.defaultModel;
        if (prompt.startsWith("model:")) {
            int index = prompt.indexOf(" ");
            model = prompt.substring("model:".length(), index);
        }
        LoggerFactory.getLogger(this.getClass()).info("using model: " + model);
        messages = messages.stream().map(Conversation::clone).collect(Collectors.toList());
        for (Conversation c : messages) {
            String content = c.getContent().trim();
            if (!content.startsWith("model:")) continue;
            int index = content.indexOf(" ");
            content = content.substring(index + 1);
            c.setContent(content);
        }
        Map<String, Boolean> input = Map.of("model", model, "messages", messages, "stream", stream);
        HttpRequest request = HttpRequest.post((CharSequence)"https://openrouter.ai/api/v1/chat/completions").header("Authorization", "Bearer " + this.apiKey).contentType("application/json;charset=utf-8");
        String body = gson.toJson(input);
        request.send((CharSequence)body);
        return request;
    }

    @Override
    protected Response createResponseFromConversation(Conversation conversation) {
        Response response = new Response();
        response.setError(false);
        response.setMessage(conversation.getContent());
        return response;
    }

    public static void main(String[] args) throws Exception {
        String link = "https://www.imsofa.rocks/post/734650527994036224/2024%E7%94%A8%E8%B6%A3%E5%91%B3%E5%95%9F%E5%8B%95%E7%A8%8B%E5%BC%8F";
        String content = HttpRequest.get((CharSequence)link).body();
        OpenrouterPuppyChatter puppyChatter = new OpenrouterPuppyChatter("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");
        String sessionId = puppyChatter.createSession();
        String prompt = "model:meta-llama/llama-3.1-8b-instruct:free \u8acb\u5f9e\u4ee5\u4e0b\u7684\u7db2\u9801\u5167\u5bb9\uff0c\u6458\u8981\u51fa\u6700\u91cd\u8981\u7684\u5167\u5bb9\uff0c\u4e26\u4ee5\u6587\u5b571000\u5b57\u4ee5\u5167\u8868\u9054\uff1a\r\n" + content;
        Object puppyResponse = puppyChatter.bark(sessionId, prompt, new PromptParameters("user"));
        System.out.println("message=" + ((Response)puppyResponse).getMessage());
        puppyChatter.closeSession(sessionId);
    }

    @Override
    protected PromptParameters createDefaultPromptParameter() {
        return new PromptParameters("user");
    }
}

