package rocks.imsofa.ai.puppychatter.prompt;

@SuppressWarnings("all")
public interface OpenAISpec {
    /**
     * get the JSON schema for the OpenAI spec
     * @return
     */

    public Class getJsonSchema();
    /**
     * set the JSON schema for the OpenAI spec
     * the given class must be a Java class comforming to the
     * Json Schema specification 2021-12 (Draft 2020-12)
     * 
     * if the schema class is set, a response_format block will
     * be gerenated like this:
     * <pre>
     * "response_format": {
     *  "type": "json_schema",
     *  "json_schema": {
     *  "name": "weather",
     *  "strict": true,
     *  "schema": {
     *    "type": "object",
     *    "properties": {
     *      "location": {"type": "string"},
     *      "temperature": {"type": "number"},
     *      "conditions": {"type": "string"}
     *    },
     *    "required": ["location", "temperature", "conditions"],
     *    "additionalProperties": false
     *   }
     *  }
     * }
     * </pre>
     * @param jsonSchema
     */
    public void setJsonSchema(Class jsonSchema);
}
