/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.cache;

import com.google.gson.Gson;
import java.io.File;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class TwoLevelFileCache {
    private File cacheRoot = null;

    public TwoLevelFileCache(File cacheRoot) {
        this.cacheRoot = cacheRoot;
    }

    public String getFromCache(String identifier) throws Exception {
        String partialKey = this.encode2PartialKey(identifier);
        File contentFolder = new File(this.cacheRoot, partialKey);
        if (!contentFolder.exists()) {
            return null;
        }
        File contentMapFile = new File(contentFolder, ".index");
        if (!contentMapFile.exists()) {
            return null;
        }
        String json = FileUtils.readFileToString((File)contentMapFile, (String)"utf-8");
        Gson gson = new Gson();
        Map contentMap = (Map)gson.fromJson(json, Map.class);
        return (String)contentMap.get(this.encode2RealKey(identifier));
    }

    public synchronized void save2Cache(String identifier, String content) throws Exception {
        String partialKey = this.encode2PartialKey(identifier);
        File contentFolder = new File(this.cacheRoot, partialKey);
        if (!contentFolder.exists()) {
            contentFolder.mkdirs();
        }
        File contentMapFile = new File(contentFolder, ".index");
        Map<String, String> contentMap = null;
        Gson gson = new Gson();
        if (!contentMapFile.exists()) {
            contentMap = new HashMap<String, String>();
        } else {
            String json = FileUtils.readFileToString((File)contentMapFile, (String)"utf-8");
            contentMap = (Map)gson.fromJson(json, Map.class);
        }
        contentMap.put(this.encode2RealKey(identifier), content);
        FileUtils.write((File)contentMapFile, (CharSequence)gson.toJson(contentMap), (String)"utf-8");
    }

    public String encode2PartialKey(String identifier) throws Exception {
        String reverse = new StringBuilder(identifier).reverse().toString();
        String base64 = Base64.getEncoder().encodeToString(identifier.getBytes());
        String base642 = Base64.getEncoder().encodeToString(reverse.getBytes());
        String key1 = base64.length() > 50 ? base64.substring(0, 50) : base64;
        String key2 = base642.length() > 50 ? base642.substring(0, 50) : base642;
        return (key1 + key2).replaceAll("\\W", "_");
    }

    public String encode2RealKey(String identifier) throws Exception {
        return identifier;
    }
}

