/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.gemini;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.FileList;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import rocks.imsofa.ai.puppychatter.gemini.drive.GoogleDriveFileContentGetter;

public class DriveTest {
    public static void main(String[] args) throws Exception {
        InputStream keyInputStream = DriveTest.class.getClassLoader().getResourceAsStream("rocks/imsofa/ai/puppychatter/api-project-437674419610-aa7964630016.json");
        GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)keyInputStream).createScoped(Collections.singleton("https://www.googleapis.com/auth/drive"));
        GsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
        Drive drive = new Drive.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), (JsonFactory)JSON_FACTORY, (HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)credentials)).setApplicationName("API Project").build();
        Drive.Files.List list = drive.files().list();
        list.setPageSize(Integer.valueOf(10));
        list.setQ("(fullText contains 'flyer' or fullText contains 'book')  and parents in '11GYNFZ6zrKWnqebDbYljrSCC6YxqDR9O'");
        list.setFields("nextPageToken, files(id, name, modifiedTime, mimeType, fileExtension, createdTime)");
        String nextPageToken = null;
        do {
            FileList fileList = (FileList)list.execute();
            List files = fileList.getFiles();
            int i = 0;
            while (i < files.size()) {
                com.google.api.services.drive.model.File file = (com.google.api.services.drive.model.File)files.get(i);
                System.out.println(file.getName());
                System.out.println(file.getMimeType() + ":" + Files.probeContentType(new File(file.getName()).toPath()));
                System.out.println(file.getFileExtension());
                System.out.println(String.valueOf(file.getCreatedTime()) + ":" + file.getModifiedTime().getValue() + ":" + System.currentTimeMillis());
                String text = GoogleDriveFileContentGetter.getTextContent(drive, file);
                System.out.println(text);
                ++i;
            }
            nextPageToken = fileList.getNextPageToken();
            System.out.println("nextPageToken=" + nextPageToken);
            list.setPageToken(nextPageToken);
        } while (nextPageToken != null);
    }
}

