/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package rocks.imsofa.ai.puppychatter;

/**
 * Parameters for configuring a prompt
 * 
 * @author USER
 */
public class PromptParameters {
    /**
     * The default verification function returns {@code VerificationResult.GOOD} if the response is not an error,
     * otherwise it returns {@code VerificationResult.GIVE_UP}.
     */
    protected ResponseVerifier responseVerifier = (r) -> {
        return (!r.isError()) ? VerificationResult.GOOD : VerificationResult.GIVE_UP;
    };
    /**
     * the role of this prompt
     * defaults to 'user'
     */
    protected String role = "user";

    public PromptParameters(String role) {
        this.role = role;
    }

    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public ResponseVerifier getResponseVerifier() {
        return responseVerifier;
    }

    public void setResponseVerifier(ResponseVerifier responseVerifier) {
        this.responseVerifier = responseVerifier;
    }

}
