/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 */

package rocks.imsofa.ai.puppychatter;

/**
 *
 * @author lendle
 */
public interface PuppyChatter<T extends PromptParameters, S extends Response> {
/**
     * initialize a chat session with 
     * a default model and
     * return a session id to be used
     * in further chats
     * @return 
     */
    public String createSession();
    /**
     * bark with default PromptParameters using a block way
     * @param sessionId
     * @param prompt
     * @return
     * @throws BarkException 
     */
    public S bark(String sessionId, String prompt) throws BarkException;

    
    /**
     * bark with default PromptParameters
     * and use a streaming-if-possible way
     * @param sessionId
     * @param prompt
     * @param parameters
     * @param barkCallback
     * @throws BarkException 
     */
    public void bark(String sessionId, String prompt, BarkCallback<S> barkCallback) throws BarkException;
    /**
     * bark with the given PromptParameters
     * @param sessionId
     * @param prompt
     * @param parameters
     * @return
     * @throws BarkException
     */
    public S bark(String sessionId, String prompt, T parameters) throws BarkException;
    /**
     * bark with the given PromptParameters and
     * use a streaming-if-possible way
     * @param sessionId
     * @param prompt
     * @param parameters
     * @param barkCallback
     * @return
     * @throws BarkException
     */
    public void bark(String sessionId, String prompt, T parameters, BarkCallback<S> barkCallback) throws BarkException;
    /**
     * close the session with the given sessionId
     * @param sessionId
     */
    public void closeSession(String sessionId);
}
