/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Main.java to edit this template
 */
package rocks.imsofa.ai.puppychatter.gemini;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.Drive.Files.List;
import com.google.api.services.drive.DriveScopes;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Collections;
import rocks.imsofa.ai.puppychatter.gemini.drive.GoogleDriveFileContentGetter;

/**
 *
 * @author USER
 */
@SuppressWarnings("all")
public class DriveTest {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws Exception {
        InputStream keyInputStream=DriveTest.class.getClassLoader().getResourceAsStream("rocks/imsofa/ai/puppychatter/api-project-437674419610-aa7964630016.json");
            
        GoogleCredentials credentials = GoogleCredentials.fromStream(keyInputStream)
                .createScoped(Collections.singleton(DriveScopes.DRIVE));
        JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
        Drive drive = new Drive.Builder(
                GoogleNetHttpTransport.newTrustedTransport(),
                JSON_FACTORY,
                new HttpCredentialsAdapter(credentials))
                .setApplicationName("API Project")
                .build();

        List list = drive.files().list();
        list.setPageSize(10);
        list.setQ("(fullText contains 'flyer' or fullText contains 'book')  and parents in '11GYNFZ6zrKWnqebDbYljrSCC6YxqDR9O'");
        list.setFields("nextPageToken, files(id, name, modifiedTime, mimeType, fileExtension, createdTime)");
        String nextPageToken=null;
        do {
            FileList fileList = list.execute();
            java.util.List<File> files=fileList.getFiles();
//            System.out.println(list.getFields());
            for (int i = 0; i < files.size(); i++) {
                File file=files.get(i);
                System.out.println(file.getName());
                System.out.println(file.getMimeType()+":"+Files.probeContentType(new java.io.File(file.getName()).toPath()));
                System.out.println(file.getFileExtension());
                System.out.println(file.getCreatedTime()+":"+file.getModifiedTime().getValue()+":"+System.currentTimeMillis());
                String text=GoogleDriveFileContentGetter.getTextContent(drive, file);
                System.out.println(text);
                /*if(file.getMimeType().contains("google")){
                    try(InputStream input=drive.files().export(file.getId(), "text/plain").executeAsInputStream()){
                        System.out.println(IOUtils.toString(input, "utf-8"));
                    }
                }else{
                    try(InputStream input=drive.files().get(file.getId()).executeMediaAsInputStream()){
                        java.io.File tempFile=new java.io.File(file.getName());
                        FileUtils.copyToFile(input, tempFile);
                        String str=TextExtractors.getDefaultInstance().extractText(tempFile);
                        System.out.println(str);
                        FileUtils.forceDelete(tempFile);
                    }catch(Exception e){e.printStackTrace();}
                }*/
//                try(InputStream input=drive.files().export(file.getId(), file.getMimeType()).executeAsInputStream()){
//                    System.out.println(IOUtils.toString(input, "utf-8"));
//                }
            }
            nextPageToken=fileList.getNextPageToken();
            System.out.println("nextPageToken="+nextPageToken);
            list.setPageToken(nextPageToken);
        }while(nextPageToken!=null);
        
    }

}
