/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package rocks.imsofa.ai.puppychatter.gemini;

import com.github.kevinsawicki.http.HttpRequest;
import com.google.auth.oauth2.AccessToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jxpath.JXPathContext;
import rocks.imsofa.ai.puppychatter.BarkException;
import rocks.imsofa.ai.puppychatter.Conversation;

/**
 *
 * @author lendle
 */
@SuppressWarnings("all")
public class SemanticRetrieval implements FactSource {
    
    protected String sourceId = null;
    protected AccessTokenProvider accessTokenProvider=null;

    public SemanticRetrieval(AccessTokenProvider accessTokenProvider, String sourceId) {
        this.accessTokenProvider=accessTokenProvider;
        this.sourceId=sourceId;
    }

    
    
    public AccessTokenProvider getAccessTokenProvider() {
        return accessTokenProvider;
    }

    public void setAccessTokenProvider(AccessTokenProvider accessTokenProvider) {
        this.accessTokenProvider = accessTokenProvider;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    @Override
    public Map toJsonPayload(List<Conversation> messages) {
        try {
            Conversation lastConversation = messages.get(messages.size() - 1);
            List<String> keywords = KeywordExtractor.getKeywords(lastConversation.getContent(), 2);
            
            List documentQuery = new ArrayList();
            Map ret=Map.of(
                    "semanticRetriever", Map.of(
                            "source", sourceId,
                            "query", Map.of(
                                    "parts", documentQuery
                            )
                    )
            );
            for (String keyword : keywords) {
                if (keyword.length() > 1) {
                    documentQuery.add(Map.of("text", keyword));
                }
            }
            documentQuery.add(0, Map.of("text", lastConversation.getContent()));
            return ret;
        } catch (BarkException ex) {
            Logger.getLogger(SemanticRetrieval.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    @Override
    public String getSummary() throws Exception{
        List<String> data = this.getChunks();
        StringBuffer buffer=new StringBuffer();
        for(String d : data){
            buffer.append(d).append("\r\n");
        }
        String allContent=buffer.toString();
        
        if(allContent.length()>20000){
            allContent=Summarizer.getSummary(allContent, 20000);
        }
        return allContent;
    }
    
    private List<String> getChunks() throws IOException {
        boolean loading = true;
        String pageToken = null;
        List<String> ret=new ArrayList<>();
        while (loading) {
            AccessToken token = accessTokenProvider.getAccessToken();
            HttpRequest request = (pageToken == null) ? HttpRequest.get("https://generativelanguage.googleapis.com/v1beta/" + sourceId + "/chunks?pageSize=100")
                    : HttpRequest.get("https://generativelanguage.googleapis.com/v1beta/" + sourceId + "/chunks?pageSize=100&pageToken=" + pageToken);
            request.header("authorization", "Bearer " + token.getTokenValue());
            String list = "" + request.body();
            Gson gson = new Gson();
            @SuppressWarnings("rawtypes")
            Map map = gson.fromJson(list, Map.class);
            JXPathContext context = JXPathContext.newContext(map);
            @SuppressWarnings({ "rawtypes", "unchecked" })
            List<Map> chunks = (List) context.getValue("//chunks", List.class);

            for (@SuppressWarnings("rawtypes") Map m : chunks) {
                JXPathContext subContext = JXPathContext.newContext(m.get("data"));
                String data = (String) subContext.getValue("/stringValue");
                ret.add(data);
            }
            pageToken = (String) map.get("nextPageToken");
            if (pageToken == null) {
                loading = false;
            }
        }
        return ret;
    }
}
