package rocks.imsofa.ai.puppychatter.openai;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import org.slf4j.LoggerFactory;

import rocks.imsofa.ai.puppychatter.AbstractPuppyChatter;
import rocks.imsofa.ai.puppychatter.BarkCallback;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.cache.CacheService;

@SuppressWarnings("all")
public abstract class OpenAICompatiblePuppyChatter<S extends OpenAICompatiblePromptParameters, T extends Response>
        extends AbstractPuppyChatter<S, T> {

    protected ToolCallProcessor toolCallProcessor;
    /**
     * the tool call requests for all sessions
     * sessionId=>toolCallId=>ToolCallRequest
     */
    protected Map<String, Map<String, ToolCallRequest>> toolCallRequests=new HashMap<>();

    public OpenAICompatiblePuppyChatter() {
        super();
    }

    public OpenAICompatiblePuppyChatter(String replyRole) {
        super(null, replyRole);
    }

    public OpenAICompatiblePuppyChatter(CacheService cacheService, String replyRole) {
        super(cacheService, replyRole);
    }

    public ToolCallProcessor getToolCallProcessor() {
        return toolCallProcessor;
    }

    public void setToolCallProcessor(ToolCallProcessor toolCallProcessor) {
        this.toolCallProcessor = toolCallProcessor;
    }

    @Override
    protected S createDefaultPromptParameter() {
        return (S) new OpenAICompatiblePromptParameters("user");
    }

    @Override
    protected T createResponseFromConversation(List<Conversation> lastPrompt, Conversation lastResponse) {
        Response response = new Response();
        response.setLastPrompt(List.copyOf(lastPrompt));
        response.setError(false);
        response.setMessage(lastResponse.getContent());
        return (T)response;
    }

    @Override
    protected boolean isCacheable(String sessionId, List<Conversation> messages, S parameters) {
        if(parameters.getTools()!=null && parameters.getTools().size()>0){
            if(cacheService!=null){
                LoggerFactory.getLogger(getClass()).warn("tools are not cacheable");
            }
            return false;
        }else{
            return super.isCacheable(sessionId, messages, parameters);
        }
    }

    
}
