/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package rocks.imsofa.ai.puppychatter.openrouter;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.jxpath.JXPathContext;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.kevinsawicki.http.HttpRequest;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.google.gson.Gson;

import rocks.imsofa.ai.puppychatter.BarkCallback;
import rocks.imsofa.ai.puppychatter.BarkException;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.cache.CacheService;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePromptParameters;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePuppyChatter;
import rocks.imsofa.ai.puppychatter.openai.Tool;
import rocks.imsofa.ai.puppychatter.openai.ToolCallRequest;

/**
 * an implementation of PuppyChatter based on Open Router
 * usage:<br/>
 * 
 * PuppyChatter&lt;PromptParameters, Response&gt; chatter=new
 * OpenrouterPuppyChatter("open router key");<br/>
 * String session=chatter.createSession();<br/>
 * Response response=chatter.bark(session, "你好", new
 * PromptParameters("user"));<br/>
 * System.out.println(response.getMessage());<br/>
 * chatter.closeSession(session);<br/>
 * 
 * when issuing prompt, a leading model:xxx can be used to specify the model to
 * use
 * 
 * @author lendle
 */
@SuppressWarnings("all")
public class OpenrouterPuppyChatterOld extends OpenAICompatiblePuppyChatter<OpenAICompatiblePromptParameters, Response> {

    private String apiKey = null;
    private String defaultModel = "meta-llama/llama-3.3-70b-instruct:free";

    public OpenrouterPuppyChatterOld(String apiKey, String defaultModel, CacheService cacheService) {
        this.apiKey = apiKey;
        this.defaultModel = defaultModel;
        this.cacheService = cacheService;
    }

    public OpenrouterPuppyChatterOld(String apiKey) {
        this(apiKey, "meta-llama/llama-3.3-70b-instruct:free", null);
    }

    public OpenrouterPuppyChatterOld(String apiKey, CacheService cacheService) {
        this(apiKey, "meta-llama/llama-3.3-70b-instruct:free", cacheService);
    }

    @Override
    protected void _bark(String sessionId, List<Conversation> messages, OpenAICompatiblePromptParameters parameters,
            BarkCallback<Response> callback) throws Exception {
        Gson gson = new Gson();
        HttpRequest request = this.constructHttpRequest(parameters, messages, true);

        Response response = new Response();
        response.setLastPrompt(List.copyOf(messages));
        response.setMessage("");
        String ret = null;
        try {
            try (InputStream inputStream = request.stream()) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
                String line = reader.readLine();
                while (line != null) {
                    line = line.trim();
                    if (line.isEmpty() == false) {
                        line = line.substring(line.indexOf(" ") + 1);
                        if ("[DONE]".equals(line) == false && "OPENROUTER PROCESSING".equals(line) == false) {
                            Response chunk = new Response();
                            // System.out.println("line="+line);
                            Map result = gson.fromJson(line, Map.class);
                            JXPathContext context = JXPathContext.newContext(result);
                            String output = (String) context.getValue("choices[1]/delta/content");
                            // String finishReason = (String) context.getValue("choices[1]/finish_reason");
                            chunk.setMessage(output);
                            response.setMessage(response.getMessage() + output);
                            callback.responseChunkReceived(chunk, false);
                        }
                    }
                    line = reader.readLine();
                }
                /**
                 * the last chunk
                 */
                Response chunk = new Response();
                chunk.setMessage(null);
                callback.responseChunkReceived(chunk, false);
            }

        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(e.getMessage() + "\r\n" + ret);
            response.setError(true);
            response.setErrorMessage(e.getMessage());
        }
        parameters.getResponseVerifier().verify(response);
    }

    @Override
    protected Response _bark(String sessionId, List<Conversation> messages, OpenAICompatiblePromptParameters parameters)
            throws Exception {
        Gson gson = new Gson();
        HttpRequest request = this.constructHttpRequest(parameters, messages, false);

        Response response = new Response();
        response.setLastPrompt(List.copyOf(messages));
        String ret = null;
        try {
            ret = request.body();
            System.out.println("ret=" + ret);
            LoggerFactory.getLogger(this.getClass()).debug("original returned message: " + ret);
            Map result = gson.fromJson(ret, Map.class);
            JXPathContext context = JXPathContext.newContext(result);
            List<Map> toolCalls=(List) context.getValue("choices[1]/message/tool_calls");
            if(toolCalls!=null && toolCalls.size()>0){
                //tool calls
                List<ToolCallRequest> toolCallsObjs=new ArrayList<>();
                for(int i=0;i<toolCalls.size();i++){
                    Map toolCall = toolCalls.get(i);
                    ToolCallRequest toolCallObj = new ToolCallRequest();
                    toolCallObj.setIndex(i);
                    toolCallObj.setId((String) toolCall.get("id"));
                    Map functionMap=(Map)toolCall.get("function");
                    // toolCallObj.setFunctionName((String) functionMap.get("name"));
                    // toolCallObj.setFunctionArguments((Map) gson.fromJson((String)functionMap.get("arguments"), Map.class));
                    toolCallsObjs.add(toolCallObj);
                }
                // response.setToolCalls(toolCallsObjs);
            }
            String output = (String) context.getValue("choices[1]/message/content");
            // String finishReason = (String) context.getValue("choices[1]/finish_reason");
            // Map message = (Map) context.getValue("choices[1]/message");

            response.setError(false);
            response.setErrorMessage(null);

            response.setMessage(output);
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(e.getMessage() + "\r\n" + ret);
            response.setError(true);
            response.setErrorMessage(e.getMessage());
        }
        return response;
    }

    private HttpRequest constructHttpRequest(OpenAICompatiblePromptParameters parameters, List<Conversation> messages,
            boolean stream) throws Exception {
        Gson gson = new Gson();
        Conversation lastConversation = messages.get(messages.size() - 1);
        String prompt = lastConversation.getContent().trim();
        String model = defaultModel;
        if (prompt.startsWith("model:")) {
            // magic string to specify a model
            int index = prompt.indexOf(" ");
            model = prompt.substring("model:".length(), index);
            // prompt = prompt.substring(index + 1);
            // lastConversation.setContent(prompt);
        } /*
           * else { //external program should do this decision
           * if (prompt.length() < 10000) {
           * //short prompt
           * if (prompt.contains("教師") || prompt.contains("json")) {
           * model = "openai/gpt-3.5-turbo-0125";
           * } else {
           * model = defaultModel;
           * }
           * } else {
           * model = "anthropic/claude-3-sonnet";
           * }
           * }
           */
        LoggerFactory.getLogger(getClass()).info("using model: " + model);

        // process conversation, remove the model: magic string
        messages = (List<Conversation>) messages.stream().map(Conversation::clone).collect(Collectors.toList());
        for (Conversation c : messages) {
            String content = c.getContent().trim();
            if (content.startsWith("model:")) {
                int index = content.indexOf(" ");
                content = content.substring(index + 1);
                c.setContent(content);
            }
        }
        Map input = new HashMap(Map.of(
                "model", model,
                "messages", messages,
                "stream", stream));
        /*
         * if the jsonSchema is not null, we will use it to generate a json schema
         * the current implementation uses victools/json-schema-generator
         */
        if (parameters.getJsonSchema() != null) {
            SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12,
                    OptionPreset.PLAIN_JSON);
            configBuilder.forFields().withRequiredCheck((field) -> {
                JsonProperty annotation = field.getAnnotationConsideringFieldAndGetter(JsonProperty.class);
                return annotation != null && annotation.required();
            });
            Map schemaMap = getSchemaMap(parameters.getJsonSchema());
            // schemaMap.put("strict", true);
            // schemaMap.put("name", parameters.getJsonSchema().getClass().getSimpleName());
            // schemaMap.remove("$schema");
            schemaMap.put("additionalProperties", false);
            input.put("response_format", Map.of(
                    "type", "json_schema",
                    "json_schema", Map.of(
                            "strict", true,
                            "name", parameters.getJsonSchema().getClass().getSimpleName(),
                            "schema", schemaMap)));
        }

        if(parameters.getTools()!=null){
            List<Map> tools = new ArrayList<>();
            for(Tool tool:parameters.getTools()){
                Map toolMap = new HashMap();
                toolMap.put("type", "function");
                Map functionMap = new HashMap();
                functionMap.put("name", tool.getName());
                functionMap.put("description", tool.getDescription());
                functionMap.put("parameters", this.getSchemaMap(tool.getParametersClass()));
                toolMap.put("function", functionMap);
                tools.add(toolMap);
            }
            input.put("tools", tools);
        }

        System.out.println("input=" + gson.toJson(input));
        HttpRequest request = HttpRequest.post("https://openrouter.ai/api/v1/chat/completions")
                .header("Authorization", "Bearer " + apiKey)
                .contentType("application/json;charset=utf-8");
        String body = gson.toJson(input);
        request.send(body);
        return request;
    }

    private Map getSchemaMap(Class schemaClass) {
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12,
                OptionPreset.PLAIN_JSON);
        configBuilder.forFields().withRequiredCheck((field)->{
            JsonProperty annotation = field.getAnnotationConsideringFieldAndGetter(JsonProperty.class);
            return annotation != null && annotation.required();
        });
        SchemaGeneratorConfig config = configBuilder.build();
        Gson gson = new Gson();
        SchemaGenerator generator = new SchemaGenerator(config);
        JsonNode jsonSchema = generator.generateSchema(schemaClass);
        String jsonString = jsonSchema.toString();
        Map schemaMap = new HashMap(gson.fromJson(jsonString, Map.class));
        return schemaMap;
    }

    public static void main(String[] args) throws Exception {
        /*
         * String link =
         * "https://www.imsofa.rocks/post/734650527994036224/2024%E7%94%A8%E8%B6%A3%E5%91%B3%E5%95%9F%E5%8B%95%E7%A8%8B%E5%BC%8F";
         * String content = HttpRequest.get(link).body();
         * OpenrouterPuppyChatter puppyChatter = new OpenrouterPuppyChatter(
         * "sk");
         * String sessionId = puppyChatter.createSession();
         * String prompt =
         * "model:meta-llama/llama-3.1-8b-instruct:free 請從以下的網頁內容，摘要出最重要的內容，並以文字1000字以內表達：\r\n"
         * + content;
         * Response puppyResponse = puppyChatter.bark(sessionId, prompt, new
         * OpenrouterPromptParameters("user"));
         * System.out.println("message=" + puppyResponse.getMessage());
         * puppyChatter.closeSession(sessionId);
         */
    }

    
}
