/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.gemini;

import com.github.kevinsawicki.http.HttpRequest;
import com.google.auth.oauth2.AccessToken;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.slf4j.LoggerFactory;
import rocks.imsofa.ai.puppychatter.AbstractPuppyChatter;
import rocks.imsofa.ai.puppychatter.BarkCallback;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.cache.CacheService;
import rocks.imsofa.ai.puppychatter.gemini.GeminiAqaPromptParameters;
import rocks.imsofa.ai.puppychatter.gemini.GeminiAqaResponse;
import rocks.imsofa.ai.puppychatter.gemini.GoogleDriveFactSource;
import rocks.imsofa.ai.puppychatter.gemini.InlinePassages;
import rocks.imsofa.ai.puppychatter.gemini.SemanticRetrieval;

public class GeminiAqaPuppyChatter
extends AbstractPuppyChatter<GeminiAqaPromptParameters, GeminiAqaResponse> {
    private String apiKey = null;

    public GeminiAqaPuppyChatter(String apiKey, CacheService cacheService) {
        super(cacheService, "assistant");
        this.apiKey = apiKey;
    }

    @Override
    protected GeminiAqaResponse _bark(String sessionId, List<Conversation> messages, GeminiAqaPromptParameters parameters) throws Exception {
        HttpRequest request = HttpRequest.post((CharSequence)("https://generativelanguage.googleapis.com/v1beta/models/aqa:generateAnswer?key=" + this.apiKey));
        request.header("Content-Type", "application/json");
        if (parameters.getSource() instanceof SemanticRetrieval) {
            AccessToken token = ((SemanticRetrieval)parameters.getSource()).accessTokenProvider.getAccessToken();
            request.header("authorization", "Bearer " + token.getTokenValue());
        }
        Conversation lastConversation = messages.get(messages.size() - 1);
        HashMap<String, List<Map<String, String>>> payload = new HashMap<String, List<Map<String, String>>>(Map.of("contents", List.of(Map.of("parts", List.of(Map.of("text", lastConversation.getContent())), "role", "user")), "answerStyle", "VERBOSE", "safetySettings", List.of(Map.of("category", "HARM_CATEGORY_HATE_SPEECH", "threshold", "BLOCK_NONE"), Map.of("category", "HARM_CATEGORY_HARASSMENT", "threshold", "BLOCK_NONE"))));
        payload.putAll(parameters.getSource().toJsonPayload(messages));
        Gson gson = new Gson();
        request.send((CharSequence)gson.toJson(payload));
        GeminiAqaResponse response = new GeminiAqaResponse();
        String reply = request.body();
        Map ret = (Map)gson.fromJson(reply, Map.class);
        JXPathContext context = JXPathContext.newContext((Object)ret);
        try {
            Map answer = (Map)context.getValue("/answer/content/parts[1]", Map.class);
            Double answerableProbability = (Double)context.getValue("//answerableProbability", Double.class);
            response.setMessage((String)answer.get("text"));
            response.setLastPrompt(List.copyOf(messages));
            response.setAnswerability(answerableProbability);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error(e.getMessage() + "\r\n" + reply);
            response.setMessage("");
            response.setAnswerability(0.0);
            response.setError(true);
            response.setErrorMessage(e.getMessage());
        }
        return response;
    }

    @Override
    protected GeminiAqaResponse createResponseFromConversation(List<Conversation> lastPrompt, Conversation lastResponse) {
        GeminiAqaResponse response = new GeminiAqaResponse();
        response.setLastPrompt(lastPrompt);
        response.setMessage(lastResponse.getContent());
        response.setAnswerability(1.0);
        return response;
    }

    @Override
    protected void _bark(String sessionId, List<Conversation> messages, GeminiAqaPromptParameters parameters, BarkCallback<GeminiAqaResponse> callback) throws Exception {
        GeminiAqaResponse response = this._bark(sessionId, messages, parameters);
        callback.responseChunkReceived(response, true);
        parameters.getResponseVerifier().verify(response);
    }

    public static void main(String[] args) throws Exception {
        String apiKey = "";
        GeminiAqaPuppyChatter puppyChatter = new GeminiAqaPuppyChatter(apiKey, null);
        String sessionId = puppyChatter.createSession();
        GeminiAqaResponse response = (GeminiAqaResponse)puppyChatter.bark(sessionId, "Socket \u600e\u9ebc\u4f7f\u7528", new GeminiAqaPromptParameters("user", new GoogleDriveFactSource("0B59IzUnV5CLjd0E2b1BWemc1N1k")));
        System.out.println(response.getMessage());
        puppyChatter.closeSession(sessionId);
    }

    @Override
    protected GeminiAqaPromptParameters createDefaultPromptParameter() {
        return new GeminiAqaPromptParameters("user", new InlinePassages());
    }
}

