/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.gemini;

import com.github.kevinsawicki.http.HttpRequest;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import rocks.imsofa.ai.puppychatter.BarkException;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.gemini.PreparedInlinePassages;
import rocks.imsofa.ai.puppychatter.gemini.Summarizer;

public class TravilyFactSource
extends PreparedInlinePassages {
    private String travilyAPIKey = null;

    public TravilyFactSource(String travilyAPIKey, String staticSummaryContent) {
        super(true, staticSummaryContent, new ArrayList<String>());
        this.travilyAPIKey = travilyAPIKey;
    }

    public TravilyFactSource(String travilyAPIKey) {
        this(travilyAPIKey, null);
    }

    @Override
    protected void preparePassages(List<Conversation> messages) throws BarkException {
        this.passages.clear();
        Gson gson = new Gson();
        String conversation = messages.get(messages.size() - 1).getContent();
        Map<String, String> request = Map.of("query", conversation, "api_key", this.travilyAPIKey);
        String str = HttpRequest.post((CharSequence)"https://api.tavily.com/search").contentType("application/json;charset=utf-8").send((CharSequence)gson.toJson(request)).body();
        Map result = (Map)gson.fromJson(str, Map.class);
        List list = (List)result.get("results");
        int wordCount = 0;
        for (int i = 0; i < list.size(); ++i) {
            Map queryReturn = (Map)list.get(i);
            String content = (String)queryReturn.get("content");
            int nextWordCount = wordCount + content.length();
            if (nextWordCount > 6000) {
                if (wordCount > 3000) break;
                content = Summarizer.getSummary(content, 1000);
            }
            this.passages.add(content);
        }
    }

    public static void main(String[] args) throws Exception {
        TravilyFactSource factSource = new TravilyFactSource("...");
        System.out.println(factSource.toJsonPayload(List.of(new Conversation("user", "\u8acb\u6bd4\u8f03java\u548cpython"))));
    }
}

