/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.openai;

import com.google.gson.Gson;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.slf4j.LoggerFactory;
import rocks.imsofa.ai.puppychatter.BarkCallback;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.PromptParameters;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.cache.CacheService;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePromptParameters;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePuppyChatter;
import rocks.imsofa.ai.puppychatter.openai.ToolCallRequest;
import rocks.imsofa.ai.puppychatter.openai.ToolCallRequestConversation;
import rocks.imsofa.ai.puppychatter.openai.ToolCallResponseConversation;

public abstract class OpenAICompatibleInputStreamPuppyChatter<S extends OpenAICompatiblePromptParameters, T extends Response>
extends OpenAICompatiblePuppyChatter<S, T> {
    public OpenAICompatibleInputStreamPuppyChatter() {
    }

    public OpenAICompatibleInputStreamPuppyChatter(String replyRole) {
        super(null, replyRole);
    }

    public OpenAICompatibleInputStreamPuppyChatter(CacheService cacheService, String replyRole) {
        super(cacheService, replyRole);
    }

    @Override
    protected T _bark(String sessionId, List<Conversation> messages, S parameters) throws Exception {
        StreamResultIterator it = this.getStreamResultIterator(sessionId, messages, parameters, false);
        return this.processResponseStreamFromLLMProviders(sessionId, it, messages, parameters, null, false);
    }

    @Override
    protected void _bark(String sessionId, List<Conversation> messages, S parameters, BarkCallback<T> callback) throws Exception {
        if (((OpenAICompatiblePromptParameters)parameters).getJsonSchema() != null || ((OpenAICompatiblePromptParameters)parameters).getTools() != null && ((OpenAICompatiblePromptParameters)parameters).getTools().size() > 0) {
            StreamResultIterator it = this.getStreamResultIterator(sessionId, messages, parameters, false);
            this.processResponseStreamFromLLMProviders(sessionId, it, messages, parameters, callback, false);
        } else {
            StreamResultIterator it = this.getStreamResultIterator(sessionId, messages, parameters, true);
            this.processResponseStreamFromLLMProviders(sessionId, it, messages, parameters, callback, true);
        }
    }

    protected abstract StreamResultIterator getStreamResultIterator(String var1, List<Conversation> var2, S var3, boolean var4) throws Exception;

    protected T processResponseStreamFromLLMProviders(String sessionId, StreamResultIterator it, List<Conversation> messages, S parameters, BarkCallback<T> callback, boolean streamed) throws Exception {
        Response response = new Response();
        response.setLastPrompt(List.copyOf(messages));
        response.setMessage("");
        String ret = null;
        Gson gson = new Gson();
        StringBuilder sb = new StringBuilder();
        try {
            while (it.hasNext()) {
                String line = it.next();
                if (callback != null && streamed) {
                    Response chunk = new Response();
                    Map result = (Map)gson.fromJson(line, Map.class);
                    JXPathContext context = JXPathContext.newContext((Object)result);
                    String output = (String)context.getValue("choices[1]/delta/content");
                    chunk.setMessage(output);
                    response.setMessage(response.getMessage() + output);
                    callback.responseChunkReceived(chunk, false);
                }
                sb.append(line).append("\r\n");
            }
            response.setMessage(sb.toString());
            if (callback == null || !streamed) {
                ret = sb.toString();
                LoggerFactory.getLogger(this.getClass()).debug("original returned message: " + ret);
                Map result = (Map)gson.fromJson(ret, Map.class);
                JXPathContext context = JXPathContext.newContext((Object)result);
                String output = (String)context.getValue("choices[1]/message/content");
                if (((OpenAICompatiblePromptParameters)parameters).getTools() != null) {
                    List toolCalls;
                    HashMap toolCallRequestMap = (HashMap)this.toolCallRequests.get(sessionId);
                    if (toolCallRequestMap == null) {
                        toolCallRequestMap = new HashMap();
                        this.toolCallRequests.put(sessionId, toolCallRequestMap);
                    }
                    if ((toolCalls = (List)context.getValue("choices[1]/message/tool_calls")) != null && toolCalls.size() > 0) {
                        ToolCallRequestConversation toolCallConversation = new ToolCallRequestConversation();
                        toolCallConversation.setRole("assistant");
                        toolCallConversation.setContent("");
                        ArrayList<ToolCallRequest> toolCallRequests = new ArrayList<ToolCallRequest>();
                        toolCallConversation.setTool_calls(toolCallRequests);
                        ToolCallRequest processingToolCallRequest = null;
                        for (int i = 0; i < toolCalls.size(); ++i) {
                            Map toolCall = (Map)toolCalls.get(i);
                            ToolCallRequest toolCallObj = null;
                            if (!toolCallRequestMap.containsKey(toolCall.get("id"))) {
                                toolCallObj = new ToolCallRequest();
                                toolCallObj.setIndex(i);
                                toolCallObj.setId((String)toolCall.get("id"));
                                Map functionMap = (Map)toolCall.get("function");
                                ToolCallRequest.Function function = new ToolCallRequest.Function();
                                function.setName((String)functionMap.get("name"));
                                function.setArguments((String)functionMap.get("arguments"));
                                toolCallObj.setFunction(function);
                            } else {
                                toolCallObj = (ToolCallRequest)toolCallRequestMap.get(toolCall.get("id"));
                            }
                            toolCallRequests.add(toolCallObj);
                            if (toolCallObj.getResponse() != null) continue;
                            processingToolCallRequest = toolCallObj;
                            break;
                        }
                        if (processingToolCallRequest != null) {
                            if (this.toolCallProcessor != null) {
                                String toolCallResponse = this.toolCallProcessor.processToolCallRequest(processingToolCallRequest);
                                processingToolCallRequest.setResponse(toolCallResponse);
                                ToolCallResponseConversation toolCallResponseConversation = new ToolCallResponseConversation("tool", processingToolCallRequest.getResponse(), processingToolCallRequest.getId(), processingToolCallRequest.getFunction().getName());
                                messages.add(toolCallConversation);
                                messages.add(toolCallResponseConversation);
                                T newResponse = this._bark(sessionId, messages, parameters);
                                output = ((Response)newResponse).getMessage();
                            } else {
                                LoggerFactory.getLogger(this.getClass()).warn("tool call processor is not set");
                                throw new Exception("tool call exists but tool call processor is not set");
                            }
                        }
                    }
                }
                response.setError(false);
                response.setErrorMessage(null);
                response.setMessage(output);
                if (callback != null && !streamed) {
                    callback.responseChunkReceived(response, true);
                    callback.finalVerificationResult(((PromptParameters)parameters).getResponseVerifier().verify(response));
                }
                return (T)response;
            }
            Response chunk = new Response();
            chunk.setMessage(null);
            callback.responseChunkReceived(chunk, true);
            callback.finalVerificationResult(((PromptParameters)parameters).getResponseVerifier().verify(response));
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error(e.getMessage() + "\r\n" + ret);
            response.setError(true);
            response.setErrorMessage(e.getMessage());
            return (T)response;
        }
        return null;
    }

    public static abstract class StreamResultIterator {
        protected InputStream inputStream;

        public StreamResultIterator(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public abstract String next();

        public abstract boolean hasNext();
    }
}

