/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.openrouter;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.kevinsawicki.http.HttpRequest;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.jxpath.JXPathContext;
import org.slf4j.LoggerFactory;
import rocks.imsofa.ai.puppychatter.BarkCallback;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.cache.CacheService;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePromptParameters;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePuppyChatter;
import rocks.imsofa.ai.puppychatter.openai.Tool;
import rocks.imsofa.ai.puppychatter.openai.ToolCallRequest;

public class OpenrouterPuppyChatterOld
extends OpenAICompatiblePuppyChatter<OpenAICompatiblePromptParameters, Response> {
    private String apiKey = null;
    private String defaultModel = "meta-llama/llama-3.3-70b-instruct:free";

    public OpenrouterPuppyChatterOld(String apiKey, String defaultModel, CacheService cacheService) {
        this.apiKey = apiKey;
        this.defaultModel = defaultModel;
        this.cacheService = cacheService;
    }

    public OpenrouterPuppyChatterOld(String apiKey) {
        this(apiKey, "meta-llama/llama-3.3-70b-instruct:free", null);
    }

    public OpenrouterPuppyChatterOld(String apiKey, CacheService cacheService) {
        this(apiKey, "meta-llama/llama-3.3-70b-instruct:free", cacheService);
    }

    @Override
    protected void _bark(String sessionId, List<Conversation> messages, OpenAICompatiblePromptParameters parameters, BarkCallback<Response> callback) throws Exception {
        Gson gson = new Gson();
        HttpRequest request = this.constructHttpRequest(parameters, messages, true);
        Response response = new Response();
        response.setLastPrompt(List.copyOf(messages));
        response.setMessage("");
        String ret = null;
        try (InputStream inputStream = request.stream();){
            Response chunk;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            String line = reader.readLine();
            while (line != null) {
                if (!((line = line.trim()).isEmpty() || "[DONE]".equals(line = line.substring(line.indexOf(" ") + 1)) || "OPENROUTER PROCESSING".equals(line))) {
                    chunk = new Response();
                    Map result = (Map)gson.fromJson(line, Map.class);
                    JXPathContext context = JXPathContext.newContext((Object)result);
                    String output = (String)context.getValue("choices[1]/delta/content");
                    chunk.setMessage(output);
                    response.setMessage(response.getMessage() + output);
                    callback.responseChunkReceived(chunk, false);
                }
                line = reader.readLine();
            }
            chunk = new Response();
            chunk.setMessage(null);
            callback.responseChunkReceived(chunk, false);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error(e.getMessage() + "\r\n" + ret);
            response.setError(true);
            response.setErrorMessage(e.getMessage());
        }
        parameters.getResponseVerifier().verify(response);
    }

    @Override
    protected Response _bark(String sessionId, List<Conversation> messages, OpenAICompatiblePromptParameters parameters) throws Exception {
        Gson gson = new Gson();
        HttpRequest request = this.constructHttpRequest(parameters, messages, false);
        Response response = new Response();
        response.setLastPrompt(List.copyOf(messages));
        String ret = null;
        try {
            ret = request.body();
            System.out.println("ret=" + ret);
            LoggerFactory.getLogger(this.getClass()).debug("original returned message: " + ret);
            Map result = (Map)gson.fromJson(ret, Map.class);
            JXPathContext context = JXPathContext.newContext((Object)result);
            List toolCalls = (List)context.getValue("choices[1]/message/tool_calls");
            if (toolCalls != null && toolCalls.size() > 0) {
                ArrayList<ToolCallRequest> toolCallsObjs = new ArrayList<ToolCallRequest>();
                for (int i = 0; i < toolCalls.size(); ++i) {
                    Map toolCall = (Map)toolCalls.get(i);
                    ToolCallRequest toolCallObj = new ToolCallRequest();
                    toolCallObj.setIndex(i);
                    toolCallObj.setId((String)toolCall.get("id"));
                    Map functionMap = (Map)toolCall.get("function");
                    toolCallsObjs.add(toolCallObj);
                }
            }
            String output = (String)context.getValue("choices[1]/message/content");
            response.setError(false);
            response.setErrorMessage(null);
            response.setMessage(output);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error(e.getMessage() + "\r\n" + ret);
            response.setError(true);
            response.setErrorMessage(e.getMessage());
        }
        return response;
    }

    private HttpRequest constructHttpRequest(OpenAICompatiblePromptParameters parameters, List<Conversation> messages, boolean stream) throws Exception {
        Gson gson = new Gson();
        Conversation lastConversation = messages.get(messages.size() - 1);
        String prompt = lastConversation.getContent().trim();
        String model = this.defaultModel;
        if (prompt.startsWith("model:")) {
            int index = prompt.indexOf(" ");
            model = prompt.substring("model:".length(), index);
        }
        LoggerFactory.getLogger(this.getClass()).info("using model: " + model);
        messages = messages.stream().map(Conversation::clone).collect(Collectors.toList());
        for (Conversation c : messages) {
            String content = c.getContent().trim();
            if (!content.startsWith("model:")) continue;
            int index = content.indexOf(" ");
            content = content.substring(index + 1);
            c.setContent(content);
        }
        HashMap<String, Boolean> input = new HashMap<String, Boolean>(Map.of("model", model, "messages", messages, "stream", stream));
        if (parameters.getJsonSchema() != null) {
            SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON);
            configBuilder.forFields().withRequiredCheck(field -> {
                JsonProperty annotation = (JsonProperty)field.getAnnotationConsideringFieldAndGetter(JsonProperty.class);
                return annotation != null && annotation.required();
            });
            Map schemaMap = this.getSchemaMap(parameters.getJsonSchema());
            schemaMap.put("additionalProperties", false);
            input.put("response_format", (Boolean)((Object)Map.of("type", "json_schema", "json_schema", Map.of("strict", true, "name", parameters.getJsonSchema().getClass().getSimpleName(), "schema", schemaMap))));
        }
        if (parameters.getTools() != null) {
            ArrayList tools = new ArrayList();
            for (Tool tool : parameters.getTools()) {
                HashMap<String, Object> toolMap = new HashMap<String, Object>();
                toolMap.put("type", "function");
                HashMap<String, Object> functionMap = new HashMap<String, Object>();
                functionMap.put("name", tool.getName());
                functionMap.put("description", tool.getDescription());
                functionMap.put("parameters", this.getSchemaMap(tool.getParametersClass()));
                toolMap.put("function", functionMap);
                tools.add(toolMap);
            }
            input.put("tools", (Boolean)((Object)tools));
        }
        System.out.println("input=" + gson.toJson(input));
        HttpRequest request = HttpRequest.post((CharSequence)"https://openrouter.ai/api/v1/chat/completions").header("Authorization", "Bearer " + this.apiKey).contentType("application/json;charset=utf-8");
        String body = gson.toJson(input);
        request.send((CharSequence)body);
        return request;
    }

    private Map getSchemaMap(Class schemaClass) {
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON);
        configBuilder.forFields().withRequiredCheck(field -> {
            JsonProperty annotation = (JsonProperty)field.getAnnotationConsideringFieldAndGetter(JsonProperty.class);
            return annotation != null && annotation.required();
        });
        SchemaGeneratorConfig config = configBuilder.build();
        Gson gson = new Gson();
        SchemaGenerator generator = new SchemaGenerator(config);
        ObjectNode jsonSchema = generator.generateSchema((Type)schemaClass, new Type[0]);
        String jsonString = jsonSchema.toString();
        HashMap schemaMap = new HashMap((Map)gson.fromJson(jsonString, Map.class));
        return schemaMap;
    }

    public static void main(String[] args) throws Exception {
    }
}

