/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package rocks.imsofa.ai.puppychatter.gemini;

import com.github.kevinsawicki.http.HttpRequest;
import com.google.auth.oauth2.AccessToken;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.slf4j.LoggerFactory;
import rocks.imsofa.ai.puppychatter.AbstractPuppyChatter;
import rocks.imsofa.ai.puppychatter.BarkCallback;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.cache.CacheService;

/**
 * an implementation of PuppyChatter that uses the google gemini aqa api<br/>
 * must be used with GeminiAqaPromptParameters and requires a fact source<br/>
 * <br/>
 * usage:<br/>
 * PuppyChatter chatter<br/>
 *               = new GeminiAqaPuppyChatter("{google api key}",<br/>
 *                       null<br/>
 *               );<br/>
 *       String sessionId=chatter.createSession();<br/>
 *       InlinePassages inlinePassages=new InlinePassages();<br/>
 *       inlinePassages.setPassages(List.of(<br/>
 *               "只見在影片中網紅酷的夢不解台灣影片在國外為何比較不紅，對此，魏德聖認為影視是最容易打文化認同的，但台灣在經濟起飛的時候選擇了科技，相比之下南韓就選擇娛樂，所以會透過電視、電影的方式來達到韓式文化的行銷，魏德聖也認為對民眾來說電影就是生活跟自己比較有關係，但是台灣選擇了台積電就跟我們比較沒關係「這是我最無力感的地方。」", <br/>
 *               "影片一曝光也引起許多網友的討論，但有許多網友表示不認同魏德聖導演的想法，網友提到韓國也是從科技業代工起來，甚至有網友認為魏德聖是在牽拖「他直接說沒受重視就好了，不用扯台積」，也有其餘網友提出電影不紅的看法「台灣電影的問題大部分是在沒辦法讓跨語種的觀眾也產生投射，也就是主題太狹窄」、「好看我會看啊～ 但國片就那樣」、「要讓台灣的電影在國外受歡迎，拜託先拍出有水準好片。」", <br/>
 *               "2+2=4"));<br/>
 *       GeminiAqaPromptParameters parameters=new GeminiAqaPromptParameters("user", inlinePassages);<br/>
 *       Response response=chatter.bark(sessionId, "台灣電影在國外爲什麼不紅", parameters);<br/>
 *       System.out.println("message="+response.getMessage());<br/>
 *       chatter.closeSession(sessionId);<br/>
 * @author USER
 * @see rocks.imsofa.ai.puppychatter.gemini.GeminiAqaPromptParameters
 */
@SuppressWarnings("all")
public class GeminiAqaPuppyChatter extends AbstractPuppyChatter<GeminiAqaPromptParameters, GeminiAqaResponse> {

    private String apiKey = null;
    public GeminiAqaPuppyChatter(String apiKey, CacheService cacheService) {
        super(cacheService, "assistant");
        this.apiKey = apiKey;
    }

    @Override
    protected GeminiAqaResponse _bark(String sessionId, List<Conversation> messages, GeminiAqaPromptParameters parameters) throws Exception {
        HttpRequest request = HttpRequest.post("https://generativelanguage.googleapis.com/v1beta/models/aqa:generateAnswer?key=" + apiKey);
        request.header("Content-Type", "application/json");

        if(parameters.getSource() instanceof SemanticRetrieval){
            AccessToken token = ((SemanticRetrieval)parameters.getSource()).accessTokenProvider.getAccessToken();
            request.header("authorization", "Bearer " + token.getTokenValue());
        }
        Conversation lastConversation = messages.get(messages.size() - 1);
        
        @SuppressWarnings({ "rawtypes" })
        Map payload = new HashMap(Map.of(
                "contents", List.of(Map.of("parts", List.of(Map.of("text", lastConversation.getContent())), "role", "user")),
                "answerStyle", "VERBOSE",
                "safetySettings",List.of(
                        Map.of("category", "HARM_CATEGORY_HATE_SPEECH", "threshold", "BLOCK_NONE"),
                        Map.of("category", "HARM_CATEGORY_HARASSMENT", "threshold", "BLOCK_NONE")
                )
        ));

        payload.putAll(parameters.getSource().toJsonPayload(messages));
//        System.out.println(payload);

        Gson gson=new Gson();
        request.send(gson.toJson(payload));
        GeminiAqaResponse response=new GeminiAqaResponse();
        String reply = request.body();
//        System.out.println("reply="+reply);
        Map ret = gson.fromJson(reply, Map.class);
        JXPathContext context = JXPathContext.newContext(ret);
        try {
            Map answer = (Map) context.getValue("/answer/content/parts[1]", Map.class);
            Double answerableProbability = (Double) context.getValue("//answerableProbability", Double.class);
            response.setMessage((String) answer.get("text"));
            response.setLastPrompt(List.copyOf(messages));
            response.setAnswerability(answerableProbability);
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(e.getMessage()+"\r\n"+reply);
            response.setMessage("");
            response.setAnswerability(0);
            response.setError(true);
            response.setErrorMessage(e.getMessage());
//            System.out.println(reply);
        }
        
        return response;
    }

    @Override
    protected GeminiAqaResponse createResponseFromConversation(List<Conversation> lastPrompt, Conversation lastResponse) {
        GeminiAqaResponse response=new GeminiAqaResponse();
        response.setLastPrompt(lastPrompt);
        response.setMessage(lastResponse.getContent());
        response.setAnswerability(1);
        return response;
    }
    /**
     * this does not really support async
     * @param sessionId
     * @param messages
     * @param parameters
     * @param callback
     * @throws Exception 
     */
    @Override
    protected void _bark(String sessionId, List<Conversation> messages, GeminiAqaPromptParameters parameters, BarkCallback<GeminiAqaResponse> callback) throws Exception {
        GeminiAqaResponse response=this._bark(sessionId, messages, parameters);
        callback.responseChunkReceived(response, true);
        parameters.getResponseVerifier().verify(response);
    }
    
    public static void main(String [] args) throws Exception{

//        String apiKey = "";
//        GeminiAqaPuppyChatter puppyChatter=new GeminiAqaPuppyChatter(apiKey, null);
//        String sessionId=puppyChatter.createSession();
//        GeminiAqaResponse response=puppyChatter.bark(sessionId, "請說明臺灣的經濟狀況變化", new GeminiAqaPromptParameters("user", 
//                new LuceneFactSource(new File("/home/lendle/dev/projects/1112/AdvisoryCenterKeywords/lucene/index/")) ));
//        System.out.println(response.getMessage());
//        puppyChatter.closeSession(sessionId);

        String apiKey = "";
        GeminiAqaPuppyChatter puppyChatter=new GeminiAqaPuppyChatter(apiKey, null);
        String sessionId=puppyChatter.createSession();
        GeminiAqaResponse response=puppyChatter.bark(sessionId, "Socket 怎麼使用", new GeminiAqaPromptParameters("user", 
                new GoogleDriveFactSource("0B59IzUnV5CLjd0E2b1BWemc1N1k", new java.io.File("c:/Users/USER/Documents/NetBeansProjects/puppychatter/src/main/resources/rocks/imsofa/ai/puppychatter/api-project-437674419610-aa7964630016.json"), "API Project")));
        System.out.println(response.getMessage());
        puppyChatter.closeSession(sessionId);
    }

    @Override
    protected GeminiAqaPromptParameters createDefaultPromptParameter() {
        return new GeminiAqaPromptParameters("user", new InlinePassages());
    }
}
