/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package rocks.imsofa.ai.puppychatter.gemini;

import com.google.gson.Gson;
import com.hankcs.hanlp.HanLP;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import rocks.imsofa.ai.puppychatter.BarkException;
import rocks.imsofa.ai.puppychatter.PuppyChatter;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.cache.FileSystemCacheService;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePromptParameters;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePuppyChatter;
import rocks.imsofa.ai.puppychatter.openrouter.OpenrouterPuppyChatter;
import rocks.imsofa.ai.puppychatter.responseverifier.JsonListResponseVerifier;

/**
 *
 * @author lendle
 */
@SuppressWarnings("all")
public class KeywordExtractor {
    public static List<String> getKeywords(String str, int size) throws BarkException{
        File cacheFolder=new File(".cache");
        if(cacheFolder.exists()==false){
            cacheFolder.mkdirs();
        }
        PuppyChatter puppyChatter=InternalPuppyChatterInitializer.getPuppyChatter();
        String sessionId=puppyChatter.createSession();
        OpenAICompatiblePromptParameters parameters=new OpenAICompatiblePromptParameters("user");
        parameters.setResponseVerifier(new JsonListResponseVerifier());
        Response response=puppyChatter.bark(sessionId, 
                "model:google/gemma-2-9b-it:free 請從以下的文字內容，擷取出 "+size+" 個關鍵字，每個關鍵字至少包含兩個字,不要有空格,並以json陣列的方式回傳，格式爲 [關鍵字1,關鍵字2]: \r\n"+str,
                parameters);
        puppyChatter.closeSession(sessionId);
        Gson gson=new Gson();
//        System.out.println(response.getMessage("application/json"));
       
        List ret=new ArrayList(gson.fromJson(response.getMessage("application/json"), List.class));
        List<String> anotherList=HanLP.extractKeyword(str, size);
        ret.addAll(anotherList);
        return ret;
    }
}
