package rocks.imsofa.ai.puppychatter.ollama;

import org.apache.poi.ss.formula.functions.T;

import rocks.imsofa.ai.puppychatter.BarkCallback;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.VerificationResult;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePromptParameters;

public class TestStream {
    public static void main(String[] args) throws Exception {
        OllamaPuppyChatter chatter = new OllamaPuppyChatter("qwen3:0.6b", null);
        String sessionId = chatter.createSession();
        OpenAICompatiblePromptParameters parameters = new OpenAICompatiblePromptParameters("user");
        chatter.bark(sessionId, "write me a story about a boy learning python", parameters, new BarkCallback<Response>() {
           public void responseChunkReceived(Response chunk, boolean isLastChunk){
               System.out.print(chunk.getMessage());
           }
            public void finalVerificationResult(VerificationResult result){
                chatter.closeSession(sessionId);
            }
        });
        // System.out.println("message=" + response.getMessage());
        
    }
}
