package rocks.imsofa.ai.puppychatter.openrouter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.cache.CacheService;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePromptParameters;
import rocks.imsofa.ai.puppychatter.rag.Chunk;
import rocks.imsofa.ai.puppychatter.rag.RagHandler;
import rocks.imsofa.ai.puppychatter.rag.RagPuppyChatter;

public class OpenrouterRagPuppyChatter extends OpenrouterPuppyChatter implements RagPuppyChatter<OpenAICompatiblePromptParameters, Response> {
    private RagHandler ragHandler;
    private Map<String, String> ragProcessing=new HashMap<>(); 

    public OpenrouterRagPuppyChatter(String apiKey, String defaultModel, CacheService cacheService) {
        super(apiKey, defaultModel, cacheService);
    }

    public OpenrouterRagPuppyChatter(String apiKey) {
        super(apiKey);
    }

    public OpenrouterRagPuppyChatter(String apiKey, CacheService cacheService) {
        super(apiKey, cacheService);
    }

    @Override
    public void setRagHandler(RagHandler ragHandler) {
        this.ragHandler = ragHandler;
    }

    @Override
    public RagHandler getRagHandler() {
        return ragHandler;
    }
    /**
     * inject rag workflow here
     */
    @Override
    protected synchronized void preprocessMessages(RequestParameters requestParameters) throws Exception {
        if (ragHandler != null && !ragProcessing.containsKey(requestParameters.getSessionId())) {
            ragProcessing.put(requestParameters.getSessionId(), "");
            List<Chunk> chunks=ragHandler.getChunks(requestParameters.getSessionId(), requestParameters.getParameters(), requestParameters.getOriginalMessages());
            List<Conversation> originalMessages=requestParameters.getEffectiveMessages();
            List<Conversation> transformedConversations=new java.util.ArrayList<>();
            Conversation transformedPrompt=ragHandler.transformLastPrompt(requestParameters.getSessionId(), requestParameters.getParameters(), originalMessages, chunks);
            for(int i=0; i<originalMessages.size(); i++){
                Conversation conversation=originalMessages.get(i);
                if(i==originalMessages.size()-1){
                    transformedConversations.add(transformedPrompt);
                }else{
                    transformedConversations.add(conversation);
                }
            }
            // System.out.println("transformedPrompt="+transformedPrompt.getContent());
            requestParameters.setEffectiveMessages(transformedConversations);
            // ragProcessing.remove(requestParameters.getSessionId());
        }else{
            return;
        }

    }
    
    
}
