package rocks.imsofa.ai.puppychatter.rag;

import java.net.URL;
import java.util.List;

import com.github.kevinsawicki.http.HttpRequest;

import rocks.imsofa.ai.puppychatter.Conversation;

public class DefaultTextContentExtractor implements TextContentExtractor {

    @Override
    public String extractTextContent(List<Conversation> messages, URL url, String charset) throws Exception {
        return HttpRequest.get(url).acceptCharset(charset).body();
    }

    @Override
    public String extractTextContent(List<Conversation> messages, URL url) {
        return HttpRequest.get(url).body();
    }

    @Override
    public String extractTextContent(List<Conversation> messages, String text) {
        return text;
    }
    
}
