package rocks.imsofa.ai.puppychatter.rag;

import java.net.URI;
import java.net.URL;
import java.util.List;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.LoggerFactory;

import com.github.kevinsawicki.http.HttpRequest;

import rocks.imsofa.ai.puppychatter.BarkException;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.PuppyChatter;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.VerificationResult;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePromptParameters;

@SuppressWarnings("all")
public class PuppyChatterTextContentExtractor implements TextContentExtractor {
    protected PuppyChatter puppyChatter;

    public PuppyChatterTextContentExtractor(PuppyChatter puppyChatter) {
        this.puppyChatter = puppyChatter;
    }

    @Override
    public String extractTextContent(List<Conversation> messages, String content) throws Exception {
        String sessionId = puppyChatter.createSession();
        String ret = null;
        try {
            
            Conversation prompt = messages.get(messages.size() - 1);

            // System.out.println(content);

            Response response = puppyChatter.bark(sessionId, "please get text content releveant to the prompt: \r\n" +
                    prompt.getContent() + "\r\n from the html page below:\r\n" + content);
            ret = response.getMessage();
            // LoggerFactory.getLogger(getClass()).info("extracted html page content=" +
            // ret.substring(0, 200));
        } catch (Exception e) {
            e.printStackTrace();
            throw e;
        } finally {
            puppyChatter.closeSession(sessionId);
        }
        return ret;
    }

    @Override
    public String extractTextContent(List<Conversation> messages, URL url, String charset) throws Exception {
        return extractTextContent(messages, HttpRequest.get(url).acceptCharset(charset).body());
    }

    @Override
    public String extractTextContent(List<Conversation> messages, URL url) throws Exception {
        return extractTextContent(messages, HttpRequest.get(url).body());
    }

}
