package rocks.imsofa.ai.puppychatter.rag;

import java.net.URL;
import java.util.List;

import rocks.imsofa.ai.puppychatter.Conversation;

public interface TextContentExtractor {
    /**
     * extract text content from a url
     * @param messages
     * @param url
     * @param charset
     * @return
     * @throws Exception
     */
    public String extractTextContent(List<Conversation> messages, URL url, String charset) throws Exception;
    /**
     * extract text content from a url using a default charset
     * @param messages
     * @param url
     * @return
     */
    public String extractTextContent(List<Conversation> messages, URL url) throws Exception;
    /**
     * extract text content from a string
     * @param messages
     * @param text
     * @return
     */
    public String extractTextContent(List<Conversation> messages, String text) throws Exception;
}
