package rocks.imsofa.ai.puppychatter.rag;

import java.util.List;
import java.util.Map;

import com.github.kevinsawicki.http.HttpRequest;
import com.google.gson.Gson;

import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.PromptParameters;
import rocks.imsofa.ai.puppychatter.rag.travily.DefaultTravilyRagHandlerCallback;
import rocks.imsofa.ai.puppychatter.rag.travily.TravilyRagHandlerCallback;

/**
 * a rag handler that use travily to extract chunks from the conversation
 */
@SuppressWarnings("all")
public class TravilyRagHandler extends AbstractTextRagHandler{
    private String travilyAPIKey;
    private TravilyRagHandlerCallback callback;

    public TravilyRagHandler(String travilyAPIKey, TravilyRagHandlerCallback callback) {
        this.travilyAPIKey = travilyAPIKey;
        this.callback = callback;
    }
    public TravilyRagHandler(String travilyAPIKey) {
        this(travilyAPIKey, new DefaultTravilyRagHandlerCallback());
    }
    @Override
    public List<Chunk> getChunks(String sessionId, PromptParameters parameters, List<Conversation> messages) {
        Conversation lastConversation = messages.get(messages.size() - 1);
        String prompt = lastConversation.getContent();
        Gson gson = new Gson();
        Map request = Map.of(
                "query", callback.getQuery(messages),
                "api_key", travilyAPIKey);
        String str = HttpRequest.post("https://api.tavily.com/search").contentType("application/json;charset=utf-8").send(gson.toJson(request)).body();
        Map result = gson.fromJson(str, Map.class);
        List list = (List) result.get("results");
        List<Chunk> chunks=new java.util.ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            Map queryReturn = (Map) list.get(i);
            if(callback.accept(chunks, queryReturn)){
                String content = (String) queryReturn.get("content");
                chunks.add(new TextChunk(content));
            }
            if(!callback.moveOn(chunks)){
                break;
            }
        }
        return chunks;
    }
    
}
