package rocks.imsofa.ai.puppychatter.rag.drive;

import java.util.List;

import org.slf4j.LoggerFactory;

import com.google.api.services.drive.model.File;
import com.hankcs.hanlp.HanLP;

import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.rag.Chunk;
import rocks.imsofa.ai.puppychatter.rag.DefaultTextContentExtractor;
import rocks.imsofa.ai.puppychatter.rag.TextContentExtractor;

public class DefaultGoogleDriveRagHandlerCallback implements GoogleDriveRagHandlerCallback{
    private TextContentExtractor textContentExtractor=new DefaultTextContentExtractor();

    public DefaultGoogleDriveRagHandlerCallback(TextContentExtractor textContentExtractor) {
        this.textContentExtractor = textContentExtractor;
    }

    public DefaultGoogleDriveRagHandlerCallback() {
        
    }

    @Override
    public boolean accept(List<Chunk> currentChunks, File nextFile) {
        return true;
    }

    @Override
    public boolean moveOn(List<Chunk> chunks) {
        long totalLength=0;
        for(Chunk chunk:chunks){
            totalLength+=chunk.getTextContent().length();
        }
        // System.out.println("totalLength="+totalLength);
        return totalLength<10000;
    }

    @Override
    public String getQuery(List<Conversation> messages, String folderId) {
        LoggerFactory.getLogger(getClass()).info(constructKeywordQuery(messages) + " and parents in '" + folderId + "'");
        String query=constructKeywordQuery(messages) + " and parents in '" + folderId + "'";
        return query;
    }
    
    private String constructKeywordQuery(List<Conversation> messages) {
        String conversation = messages.get(messages.size() - 1).getContent();
        List<String> keywords = HanLP.extractKeyword(conversation, 5);

        StringBuilder sb = new StringBuilder();
        for (String keyword : keywords) {
            if (!sb.isEmpty()) {
                sb.append(" or ");
            }
            sb.append("fullText contains '" + keyword + "'");
        }
        return "(" + sb.toString() + ")";
    }



    public TextContentExtractor getTextContentExtractor() {
        return textContentExtractor;
    }
}
