/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package rocks.imsofa.ai.puppychatter.responseverifier;

import com.google.gson.Gson;
import java.util.List;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.ResponseVerifier;
import rocks.imsofa.ai.puppychatter.VerificationResult;

/**
 *
 * @author USER
 */
public class JsonListResponseVerifier implements ResponseVerifier{
    private Gson gson=new Gson();
    @Override
    public VerificationResult verify(Response response) {
        if(response.isError()){
            return VerificationResult.GIVE_UP;
        }
        try{
            gson.fromJson(response.getMessage(), List.class);
        }catch(Throwable e){
            return VerificationResult.TRY_AGAIN;
        }
        return VerificationResult.GOOD;
    }
    
}
