/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.cache;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.LoggerFactory;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.cache.CacheService;
import rocks.imsofa.ai.puppychatter.cache.FileCachedConversation;

public class FileSystemCacheService
implements CacheService {
    private File rootFolder = new File(".");

    public FileSystemCacheService(File rootFolder) {
        this.rootFolder = rootFolder;
    }

    public FileSystemCacheService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Conversation getCachedReply(List<Conversation> conversations) throws Exception {
        List<Conversation> bound = this.sync2BoundConversations(conversations);
        FileCachedConversation fc = (FileCachedConversation)bound.get(bound.size() - 1);
        File targetDir = fc.getContainerFolderFile();
        if (targetDir == null) {
            return null;
        }
        FileSystemCacheService fileSystemCacheService = this;
        synchronized (fileSystemCacheService) {
            File indexFile = new File(targetDir, ".index");
            if (!indexFile.exists()) {
                return null;
            }
            Gson gson = new Gson();
            Map map = (Map)gson.fromJson(FileUtils.readFileToString((File)indexFile, (String)"utf-8"), Map.class);
            String realKey = this.getRealKey(bound);
            String text = (String)map.get(realKey);
            Conversation ret = (Conversation)gson.fromJson(text, Conversation.class);
            LoggerFactory.getLogger((String)this.getClass().getName()).info("check cache with realKey=" + realKey + "\r\n\tand ret=" + text);
            return ret;
        }
    }

    @Override
    public List<Conversation> sync2BoundConversations(List<Conversation> conversations) throws Exception {
        File currentFolder = this.rootFolder;
        ArrayList<Conversation> ret = new ArrayList<Conversation>();
        boolean synced = true;
        for (Conversation c : conversations) {
            if (c instanceof FileCachedConversation) continue;
            synced = false;
            break;
        }
        if (synced) {
            return conversations;
        }
        for (Conversation c : conversations) {
            FileCachedConversation fc;
            if (c instanceof FileCachedConversation) {
                fc = (FileCachedConversation)c;
                ret.add(fc);
                currentFolder = fc.getContainerFolderFile();
                continue;
            }
            fc = this.save2Folder(c, currentFolder);
            ret.add(fc);
            currentFolder = fc.getContainerFolderFile();
        }
        return ret;
    }

    private synchronized FileCachedConversation save2Folder(Conversation originalConversation, File parentContainerFolder) throws IOException {
        String key = this.getPartialKey(originalConversation.getContent());
        File containerFolder = new File(parentContainerFolder, key);
        if (!containerFolder.exists() || !containerFolder.isDirectory()) {
            containerFolder.mkdirs();
        }
        FileCachedConversation fc = new FileCachedConversation(containerFolder.getAbsolutePath());
        fc.setContainerFolder(new File(parentContainerFolder, key).getAbsolutePath());
        fc.setRole(originalConversation.getRole());
        fc.setContent(originalConversation.getContent());
        return fc;
    }

    private String getPartialKey(String text) {
        if (text.startsWith("model:")) {
            int index = text.indexOf(" ");
            text = text.substring(index + 1);
        }
        String reverse = new StringBuilder(text).reverse().toString();
        String base64 = Base64.getEncoder().encodeToString(text.getBytes());
        String base642 = Base64.getEncoder().encodeToString(reverse.getBytes());
        String key1 = base64.length() > 50 ? base64.substring(0, 50) : base64;
        String key2 = base642.length() > 50 ? base642.substring(0, 50) : base642;
        return (key1 + key2).replaceAll("\\W", "_");
    }

    @Override
    public void cacheReply(List<Conversation> query, Conversation reply) throws Exception {
        List<Conversation> boundQuery = this.sync2BoundConversations(query);
        FileCachedConversation fileCachedConversation = (FileCachedConversation)boundQuery.get(boundQuery.size() - 1);
        File folder = fileCachedConversation.getContainerFolderFile();
        File indexFile = new File(folder, ".index");
        Map<String, String> map = null;
        Gson gson = new Gson();
        String realKey = this.getRealKey(query);
        String serialized = gson.toJson((Object)reply);
        LoggerFactory.getLogger((String)this.getClass().getName()).info("save to cache inside folder: " + String.valueOf(folder) + " with realKey=" + realKey);
        if (!indexFile.exists()) {
            map = new HashMap<String, String>();
            map.put(realKey, serialized);
            FileUtils.write((File)indexFile, (CharSequence)gson.toJson(map), (String)"utf-8");
        } else {
            String str = FileUtils.readFileToString((File)indexFile, (String)"utf-8");
            map = (Map)gson.fromJson(str, Map.class);
            map.put(realKey, serialized);
            FileUtils.write((File)indexFile, (CharSequence)gson.toJson(map), (String)"utf-8");
        }
    }

    public String getRealKey(List<Conversation> query) {
        Gson gson = new Gson();
        ArrayList<String> allMessages = new ArrayList<String>();
        for (Conversation c : query) {
            String text = c.getContent();
            if (text.startsWith("model:")) {
                int index = text.indexOf(" ");
                text = text.substring(index + 1);
            }
            allMessages.add(text);
        }
        String realKey = gson.toJson(allMessages);
        return realKey;
    }

    @Override
    public void removeCache(List<Conversation> conversations) throws Exception {
        List<Conversation> synced = this.sync2BoundConversations(conversations);
        FileCachedConversation fc = (FileCachedConversation)synced.get(0);
        FileUtils.deleteDirectory((File)fc.getContainerFolderFile());
    }
}

