/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.gemini;

import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePuppyChatter;
import rocks.imsofa.ai.puppychatter.openrouter.OpenrouterPuppyChatter;

public class InternalPuppyChatterInitializer {
    private static OpenAICompatiblePuppyChatter puppyChatter = null;

    public static synchronized void setPuppyChatter(OpenAICompatiblePuppyChatter puppyChatter) {
        InternalPuppyChatterInitializer.puppyChatter = puppyChatter;
    }

    public static synchronized OpenAICompatiblePuppyChatter getPuppyChatter() {
        if (puppyChatter == null) {
            String apiKey = System.getenv("PUPPYCHATTER_OPENROUTER_API_KEY");
            String defaultModel = System.getenv("PUPPYCHATTER_OPENROUTER_DEFAULT_MODEL");
            if (apiKey == null) {
                apiKey = System.getProperty("PUPPYCHATTER_OPENROUTER_API_KEY");
            }
            if (defaultModel == null) {
                defaultModel = System.getProperty("PUPPYCHATTER_OPENROUTER_DEFAULT_MODEL");
            }
            if (apiKey == null || defaultModel == null) {
                throw new IllegalStateException("PuppyChatter is not initialized. Please set the environment variables PUPPYCHATTER_OPENROUTER_API_KEY and PUPPYCHATTER_OPENROUTER_DEFAULT_MODEL.");
            }
            puppyChatter = new OpenrouterPuppyChatter(apiKey, defaultModel, null);
        }
        return puppyChatter;
    }
}

