/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.ollama;

import com.github.kevinsawicki.http.HttpRequest;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.IOUtils;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.cache.CacheService;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatibleInputStreamPuppyChatter;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePromptParameters;

public class OllamaPuppyChatter
extends OpenAICompatibleInputStreamPuppyChatter<OpenAICompatiblePromptParameters, Response> {
    private String model = null;
    private CacheService cacheService = null;

    public OllamaPuppyChatter(String model, CacheService cacheService) {
        super(cacheService, "user");
        this.model = model;
    }

    @Override
    protected OpenAICompatibleInputStreamPuppyChatter.StreamResultIterator getStreamResultIterator(OpenAICompatibleInputStreamPuppyChatter.RequestParameters requestParameters) throws Exception {
        final HttpRequest request = requestParameters.getHttpRequest();
        return new OpenAICompatibleInputStreamPuppyChatter.StreamResultIterator(request.stream()){
            private BufferedReader reader;
            private String nextLine;
            {
                super(inputStream);
                this.reader = null;
                this.nextLine = null;
            }

            @Override
            public String next() {
                return this.nextLine;
            }

            private void closeReader() {
                if (this.reader != null) {
                    IOUtils.closeQuietly((Reader)this.reader);
                    this.reader = null;
                }
            }

            @Override
            public boolean hasNext() {
                try {
                    String line;
                    if (this.reader == null) {
                        this.reader = new BufferedReader(new InputStreamReader(request.stream(), "utf-8"));
                    }
                    if ((line = this.reader.readLine()) == null) {
                        this.closeReader();
                        return false;
                    }
                    while (line != null) {
                        if (!(line = line.trim()).isEmpty()) {
                            String string = line = line.startsWith("{") ? line : line.substring(line.indexOf(" ") + 1);
                            if (!"[DONE]".equals(line)) break;
                            line = this.reader.readLine();
                            continue;
                        }
                        line = this.reader.readLine();
                    }
                    if (line == null) {
                        this.closeReader();
                        return false;
                    }
                    this.nextLine = line;
                    return true;
                }
                catch (Exception e) {
                    this.closeReader();
                    return false;
                }
            }
        };
    }

    @Override
    protected OpenAICompatibleInputStreamPuppyChatter.RequestParameters getRequestParameters(String sessionId, List<Conversation> messages, OpenAICompatiblePromptParameters parameters, boolean streamed) throws Exception {
        OpenAICompatibleInputStreamPuppyChatter.RequestParameters requestParameters = new OpenAICompatibleInputStreamPuppyChatter.RequestParameters();
        requestParameters.setOriginalMessages(messages);
        requestParameters.setStream(streamed);
        requestParameters.setParameters(parameters);
        requestParameters.setModel(this.model);
        HttpRequest request = HttpRequest.post((CharSequence)"http://localhost:11434/v1/chat/completions").contentType("application/json;charset=utf-8");
        requestParameters.setHttpRequest(request);
        Conversation lastConversation = messages.get(messages.size() - 1);
        String prompt = lastConversation.getContent().trim();
        requestParameters.setEffectiveMessages(messages);
        return requestParameters;
    }
}

