/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.openrouter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.cache.CacheService;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatibleInputStreamPuppyChatter;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePromptParameters;
import rocks.imsofa.ai.puppychatter.openrouter.OpenrouterPuppyChatter;
import rocks.imsofa.ai.puppychatter.rag.Chunk;
import rocks.imsofa.ai.puppychatter.rag.RagHandler;
import rocks.imsofa.ai.puppychatter.rag.RagPuppyChatter;

public class OpenrouterRagPuppyChatter
extends OpenrouterPuppyChatter
implements RagPuppyChatter<OpenAICompatiblePromptParameters, Response> {
    private RagHandler ragHandler;
    private Map<String, String> ragProcessing = new HashMap<String, String>();

    public OpenrouterRagPuppyChatter(String apiKey, String defaultModel, CacheService cacheService) {
        super(apiKey, defaultModel, cacheService);
    }

    public OpenrouterRagPuppyChatter(String apiKey) {
        super(apiKey);
    }

    public OpenrouterRagPuppyChatter(String apiKey, CacheService cacheService) {
        super(apiKey, cacheService);
    }

    @Override
    public void setRagHandler(RagHandler ragHandler) {
        this.ragHandler = ragHandler;
    }

    @Override
    public RagHandler getRagHandler() {
        return this.ragHandler;
    }

    @Override
    protected synchronized void preprocessMessages(OpenAICompatibleInputStreamPuppyChatter.RequestParameters requestParameters) throws Exception {
        ArrayList<Conversation> transformedConversations;
        if (this.ragHandler != null && !this.ragProcessing.containsKey(requestParameters.getSessionId())) {
            this.ragProcessing.put(requestParameters.getSessionId(), "");
            List<Chunk> chunks = this.ragHandler.getChunks(requestParameters.getSessionId(), requestParameters.getParameters(), requestParameters.getOriginalMessages());
            List<Conversation> originalMessages = requestParameters.getEffectiveMessages();
            transformedConversations = new ArrayList<Conversation>();
            Conversation transformedPrompt = this.ragHandler.transformLastPrompt(requestParameters.getSessionId(), requestParameters.getParameters(), originalMessages, chunks);
            for (int i = 0; i < originalMessages.size(); ++i) {
                Conversation conversation = originalMessages.get(i);
                if (i == originalMessages.size() - 1) {
                    transformedConversations.add(transformedPrompt);
                    continue;
                }
                transformedConversations.add(conversation);
            }
        } else {
            return;
        }
        requestParameters.setEffectiveMessages(transformedConversations);
    }
}

