/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.rag;

import com.github.kevinsawicki.http.HttpRequest;
import com.google.gson.Gson;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.PromptParameters;
import rocks.imsofa.ai.puppychatter.cache.TwoLevelFileCache;
import rocks.imsofa.ai.puppychatter.rag.AbstractTextRagHandler;
import rocks.imsofa.ai.puppychatter.rag.Chunk;
import rocks.imsofa.ai.puppychatter.rag.TextChunk;
import rocks.imsofa.ai.puppychatter.rag.googlesearch.DefaultGoogleSearchRagHandlerCallback;
import rocks.imsofa.ai.puppychatter.rag.googlesearch.GoogleSearchRagHandlerCallback;

public class GoogleSearchRagHandler
extends AbstractTextRagHandler {
    private String apiKey;
    private String searchEngineId;
    private TwoLevelFileCache queryResultCache = null;
    private TwoLevelFileCache linkCache = null;
    private GoogleSearchRagHandlerCallback callback;

    public GoogleSearchRagHandler(String apiKey, String searchEngineId, GoogleSearchRagHandlerCallback callback) {
        this.apiKey = apiKey;
        this.searchEngineId = searchEngineId;
        this.callback = callback;
    }

    public GoogleSearchRagHandler(String apiKey, String searchEngineId) {
        this(apiKey, searchEngineId, new DefaultGoogleSearchRagHandlerCallback(""));
    }

    @Override
    public List<Chunk> getChunks(String sessionId, PromptParameters parameters, List<Conversation> messages) throws Exception {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        File cacheFolder = new File(".cache");
        File googleSearchCache = new File(cacheFolder, ".google");
        File queryResultCacheFolder = new File(googleSearchCache, ".result");
        File linkCacheFolder = new File(googleSearchCache, ".link");
        if (!queryResultCacheFolder.exists()) {
            queryResultCacheFolder.mkdirs();
        }
        if (!linkCacheFolder.exists()) {
            linkCacheFolder.mkdirs();
        }
        this.queryResultCache = new TwoLevelFileCache(queryResultCacheFolder);
        this.linkCache = new TwoLevelFileCache(linkCacheFolder);
        String query = this.callback.getQuery(messages);
        Map<String, Object> resp = this.getQueryResult(this.queryResultCache, this.apiKey, this.searchEngineId, query);
        if (resp.containsKey("items")) {
            ArrayList<String> links = new ArrayList<String>();
            List items = (List)resp.get("items");
            for (Map item : items) {
                try {
                    String link = (String)item.get("link");
                    if (!this.callback.accept(chunks, link)) continue;
                    links.add(link);
                    String content = this.getLinkContent(this.linkCache, messages, link);
                    chunks.add(new TextChunk(content));
                    if (this.callback.moveOn(chunks)) continue;
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new Exception(ex);
                }
            }
        } else {
            throw new Exception("no match in query");
        }
        return chunks;
    }

    private Map<String, Object> getQueryResult(TwoLevelFileCache queryResultCache, String apiKey, String searchEngineId, String query) throws Exception {
        Gson gson = new Gson();
        String queryResultJson = queryResultCache.getFromCache(query);
        if (queryResultJson != null) {
            return (Map)gson.fromJson(queryResultJson, Map.class);
        }
        HttpRequest request = HttpRequest.get((CharSequence)"https://www.googleapis.com/customsearch/v1", (boolean)true, (Object[])new Object[]{"key", apiKey, "cx", searchEngineId, "q", query});
        String response = request.body();
        Map resp = (Map)gson.fromJson(response, Map.class);
        if (resp.containsKey("items")) {
            queryResultCache.save2Cache(query, response);
        }
        return resp;
    }

    private String getLinkContent(TwoLevelFileCache linkCache, List<Conversation> messages, String link) throws Exception {
        String content = linkCache.getFromCache(link);
        if (content != null) {
            return content;
        }
        content = this.callback.getHtmlPageContentExtractor().extractTextContent(messages, new URI(link).toURL());
        return content;
    }
}

