/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.rag;

import com.github.kevinsawicki.http.HttpRequest;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.PromptParameters;
import rocks.imsofa.ai.puppychatter.rag.AbstractTextRagHandler;
import rocks.imsofa.ai.puppychatter.rag.Chunk;
import rocks.imsofa.ai.puppychatter.rag.TextChunk;
import rocks.imsofa.ai.puppychatter.rag.travily.DefaultTravilyRagHandlerCallback;
import rocks.imsofa.ai.puppychatter.rag.travily.TravilyRagHandlerCallback;

public class TravilyRagHandler
extends AbstractTextRagHandler {
    private String travilyAPIKey;
    private TravilyRagHandlerCallback callback;

    public TravilyRagHandler(String travilyAPIKey, TravilyRagHandlerCallback callback) {
        this.travilyAPIKey = travilyAPIKey;
        this.callback = callback;
    }

    public TravilyRagHandler(String travilyAPIKey) {
        this(travilyAPIKey, new DefaultTravilyRagHandlerCallback());
    }

    @Override
    public List<Chunk> getChunks(String sessionId, PromptParameters parameters, List<Conversation> messages) {
        Conversation lastConversation = messages.get(messages.size() - 1);
        String prompt = lastConversation.getContent();
        Gson gson = new Gson();
        Map<String, String> request = Map.of("query", this.callback.getQuery(messages), "api_key", this.travilyAPIKey);
        String str = HttpRequest.post((CharSequence)"https://api.tavily.com/search").contentType("application/json;charset=utf-8").send((CharSequence)gson.toJson(request)).body();
        Map result = (Map)gson.fromJson(str, Map.class);
        List list = (List)result.get("results");
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        for (int i = 0; i < list.size(); ++i) {
            Map queryReturn = (Map)list.get(i);
            if (this.callback.accept(chunks, queryReturn)) {
                String content = (String)queryReturn.get("content");
                chunks.add(new TextChunk(content));
            }
            if (!this.callback.moveOn(chunks)) break;
        }
        return chunks;
    }
}

