/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.rag.drive;

import com.google.api.services.drive.model.File;
import com.hankcs.hanlp.HanLP;
import java.util.List;
import org.slf4j.LoggerFactory;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.rag.Chunk;
import rocks.imsofa.ai.puppychatter.rag.DefaultTextContentExtractor;
import rocks.imsofa.ai.puppychatter.rag.TextContentExtractor;
import rocks.imsofa.ai.puppychatter.rag.drive.GoogleDriveRagHandlerCallback;

public class DefaultGoogleDriveRagHandlerCallback
implements GoogleDriveRagHandlerCallback {
    private TextContentExtractor textContentExtractor = new DefaultTextContentExtractor();

    public DefaultGoogleDriveRagHandlerCallback(TextContentExtractor textContentExtractor) {
        this.textContentExtractor = textContentExtractor;
    }

    public DefaultGoogleDriveRagHandlerCallback() {
    }

    @Override
    public boolean accept(List<Chunk> currentChunks, File nextFile) {
        return true;
    }

    @Override
    public boolean moveOn(List<Chunk> chunks) {
        long totalLength = 0L;
        for (Chunk chunk : chunks) {
            totalLength += (long)chunk.getTextContent().length();
        }
        return totalLength < 10000L;
    }

    @Override
    public String getQuery(List<Conversation> messages, String folderId) {
        LoggerFactory.getLogger(this.getClass()).info(this.constructKeywordQuery(messages) + " and parents in '" + folderId + "'");
        String query = this.constructKeywordQuery(messages) + " and parents in '" + folderId + "'";
        return query;
    }

    private String constructKeywordQuery(List<Conversation> messages) {
        String conversation = messages.get(messages.size() - 1).getContent();
        List keywords = HanLP.extractKeyword((String)conversation, (int)5);
        StringBuilder sb = new StringBuilder();
        for (String keyword : keywords) {
            if (!sb.isEmpty()) {
                sb.append(" or ");
            }
            sb.append("fullText contains '" + keyword + "'");
        }
        return "(" + sb.toString() + ")";
    }

    @Override
    public TextContentExtractor getTextContentExtractor() {
        return this.textContentExtractor;
    }
}

