/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.gemini;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.FileList;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rocks.imsofa.ai.puppychatter.BarkException;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.gemini.KeywordExtractor;
import rocks.imsofa.ai.puppychatter.gemini.PreparedInlinePassages;
import rocks.imsofa.ai.puppychatter.gemini.Summarizer;
import rocks.imsofa.ai.puppychatter.gemini.drive.GoogleDriveFileContentGetter;

public class GoogleDriveFactSource
extends PreparedInlinePassages {
    private String folderId;
    private File serviceAccountKeyFile;
    private String googleApplicationName;

    public GoogleDriveFactSource(String folderId, String staticSummaryContent, File serviceAccountKeyFile, String googleApplicationName) {
        super(true, staticSummaryContent, new ArrayList<String>());
        this.folderId = folderId;
        this.serviceAccountKeyFile = serviceAccountKeyFile;
        this.googleApplicationName = googleApplicationName;
    }

    public GoogleDriveFactSource(String folderId, File serviceAccountKeyFile, String googleApplicationName) {
        this(folderId, null, serviceAccountKeyFile, googleApplicationName);
    }

    @Override
    protected void preparePassages(List<Conversation> messages) throws BarkException {
        this.passages.clear();
        try (FileInputStream keyInputStream = new FileInputStream(this.serviceAccountKeyFile);){
            GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)keyInputStream).createScoped(Collections.singleton("https://www.googleapis.com/auth/drive"));
            GsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
            Drive drive = new Drive.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), (JsonFactory)JSON_FACTORY, (HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)credentials)).setApplicationName(this.googleApplicationName).build();
            Drive.Files.List list = drive.files().list();
            list.setPageSize(Integer.valueOf(10));
            System.out.println(this.constructKeywordQuery(messages) + " and parents in '" + this.folderId + "'");
            list.setQ(this.constructKeywordQuery(messages) + " and parents in '" + this.folderId + "'");
            list.setFields("nextPageToken, files(id, name, modifiedTime, mimeType, fileExtension, createdTime)");
            String nextPageToken = null;
            FileList fileList = (FileList)list.execute();
            List files = fileList.getFiles();
            long totalLength = 0L;
            for (int i = 0; i < files.size(); ++i) {
                com.google.api.services.drive.model.File file = (com.google.api.services.drive.model.File)files.get(i);
                String textContent = null;
                try {
                    textContent = GoogleDriveFileContentGetter.getTextContent(drive, file);
                }
                catch (Exception e) {
                    System.out.println(file.getName());
                    continue;
                }
                if (textContent.length() > 1000) {
                    textContent = Summarizer.getSummary(textContent, 1000);
                }
                this.passages.add(textContent);
                if ((totalLength += (long)textContent.length()) >= 5000L) break;
            }
            nextPageToken = fileList.getNextPageToken();
            list.setPageToken(nextPageToken);
        }
        catch (Exception e) {
            throw new BarkException(e);
        }
    }

    private String constructKeywordQuery(List<Conversation> messages) throws BarkException {
        String conversation = messages.get(messages.size() - 1).getContent();
        List<String> keywords = KeywordExtractor.getKeywords(conversation, 5);
        StringBuilder sb = new StringBuilder();
        for (String keyword : keywords) {
            if (!sb.isEmpty()) {
                sb.append(" or ");
            }
            sb.append("fullText contains '" + keyword + "'");
        }
        return "(" + sb.toString() + ")";
    }

    public static void main(String[] args) throws Exception {
        GoogleDriveFactSource factSource = new GoogleDriveFactSource("11GYNFZ6zrKWnqebDbYljrSCC6YxqDR9O", new File("c:/Users/USER/Documents/NetBeansProjects/puppychatter/src/main/resources/rocks/imsofa/ai/puppychatter/api-project-437674419610-aa7964630016.json"), "API Project");
        System.out.println(factSource.toJsonPayload(List.of(new Conversation("user", "flyer related books"))));
    }
}

