/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.openrouter;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.kevinsawicki.http.HttpRequest;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.cache.CacheService;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatibleInputStreamPuppyChatter;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePromptParameters;

public class OpenrouterPuppyChatter
extends OpenAICompatibleInputStreamPuppyChatter<OpenAICompatiblePromptParameters, Response> {
    private String apiKey = null;
    private String defaultModel = "meta-llama/llama-3.3-70b-instruct:free";

    public OpenrouterPuppyChatter(String apiKey, String defaultModel, CacheService cacheService) {
        this.apiKey = apiKey;
        this.defaultModel = defaultModel;
        this.cacheService = cacheService;
    }

    public OpenrouterPuppyChatter(String apiKey) {
        this(apiKey, "meta-llama/llama-3.3-70b-instruct:free", null);
    }

    public OpenrouterPuppyChatter(String apiKey, CacheService cacheService) {
        this(apiKey, "meta-llama/llama-3.3-70b-instruct:free", cacheService);
    }

    private Map getSchemaMap(Class schemaClass) {
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON);
        configBuilder.forFields().withRequiredCheck(field -> {
            JsonProperty annotation = (JsonProperty)field.getAnnotationConsideringFieldAndGetter(JsonProperty.class);
            return annotation != null && annotation.required();
        });
        SchemaGeneratorConfig config = configBuilder.build();
        Gson gson = new Gson();
        SchemaGenerator generator = new SchemaGenerator(config);
        ObjectNode jsonSchema = generator.generateSchema((Type)schemaClass, new Type[0]);
        String jsonString = jsonSchema.toString();
        HashMap schemaMap = new HashMap((Map)gson.fromJson(jsonString, Map.class));
        return schemaMap;
    }

    public static void main(String[] args) throws Exception {
    }

    @Override
    protected OpenAICompatibleInputStreamPuppyChatter.StreamResultIterator getStreamResultIterator(OpenAICompatibleInputStreamPuppyChatter.RequestParameters requestParameters) throws Exception {
        final HttpRequest request = requestParameters.getHttpRequest();
        return new OpenAICompatibleInputStreamPuppyChatter.StreamResultIterator(request.stream()){
            private BufferedReader reader;
            private String nextLine;
            {
                super(inputStream);
                this.reader = null;
                this.nextLine = null;
            }

            @Override
            public String next() {
                return this.nextLine;
            }

            private void closeReader() {
                if (this.reader != null) {
                    IOUtils.closeQuietly((Reader)this.reader);
                    this.reader = null;
                }
            }

            @Override
            public boolean hasNext() {
                try {
                    String line;
                    if (this.reader == null) {
                        this.reader = new BufferedReader(new InputStreamReader(request.stream(), "utf-8"));
                    }
                    if ((line = this.reader.readLine()) == null) {
                        this.closeReader();
                        return false;
                    }
                    while (line != null) {
                        if (!(line = line.trim()).isEmpty()) {
                            String string = line = line.startsWith("{") ? line : line.substring(line.indexOf(" ") + 1);
                            if (!"[DONE]".equals(line) && !"OPENROUTER PROCESSING".equals(line)) break;
                            line = this.reader.readLine();
                            continue;
                        }
                        line = this.reader.readLine();
                    }
                    if (line == null) {
                        this.closeReader();
                        return false;
                    }
                    this.nextLine = line;
                    return true;
                }
                catch (Exception e) {
                    this.closeReader();
                    return false;
                }
            }
        };
    }

    @Override
    protected OpenAICompatibleInputStreamPuppyChatter.RequestParameters getRequestParameters(String sessionId, List<Conversation> messages, OpenAICompatiblePromptParameters parameters, boolean streamed) throws Exception {
        OpenAICompatibleInputStreamPuppyChatter.RequestParameters requestParameters = new OpenAICompatibleInputStreamPuppyChatter.RequestParameters();
        requestParameters.setOriginalMessages(messages);
        requestParameters.setStream(streamed);
        requestParameters.setParameters(parameters);
        requestParameters.setModel(this.defaultModel);
        HttpRequest request = HttpRequest.post((CharSequence)"https://openrouter.ai/api/v1/chat/completions").header("Authorization", "Bearer " + this.apiKey).contentType("application/json;charset=utf-8");
        requestParameters.setHttpRequest(request);
        Conversation lastConversation = messages.get(messages.size() - 1);
        String prompt = lastConversation.getContent().trim();
        String model = this.defaultModel;
        if (prompt.startsWith("model:")) {
            int index = prompt.indexOf(" ");
            model = prompt.substring("model:".length(), index);
            requestParameters.setModel(model);
        }
        List<Conversation> effectiveMessages = messages.stream().map(Conversation::clone).collect(Collectors.toList());
        for (Conversation c : effectiveMessages) {
            String content = c.getContent().trim();
            if (!content.startsWith("model:")) continue;
            int index = content.indexOf(" ");
            content = content.substring(index + 1);
            c.setContent(content);
        }
        requestParameters.setEffectiveMessages(effectiveMessages);
        return requestParameters;
    }
}

