/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.rag;

import com.github.kevinsawicki.http.HttpRequest;
import java.net.URL;
import java.util.List;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.PuppyChatter;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.rag.TextContentExtractor;

public class PuppyChatterTextContentExtractor
implements TextContentExtractor {
    protected PuppyChatter puppyChatter;

    public PuppyChatterTextContentExtractor(PuppyChatter puppyChatter) {
        this.puppyChatter = puppyChatter;
    }

    @Override
    public String extractTextContent(List<Conversation> messages, String content) throws Exception {
        String sessionId = this.puppyChatter.createSession();
        String ret = null;
        try {
            Conversation prompt = messages.get(messages.size() - 1);
            Object response = this.puppyChatter.bark(sessionId, "please get text content releveant to the prompt: \r\n" + prompt.getContent() + "\r\n from the html page below:\r\n" + content);
            ret = ((Response)response).getMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.puppyChatter.closeSession(sessionId);
        }
        return ret;
    }

    @Override
    public String extractTextContent(List<Conversation> messages, URL url, String charset) throws Exception {
        return this.extractTextContent(messages, HttpRequest.get((URL)url).acceptCharset(charset).body());
    }

    @Override
    public String extractTextContent(List<Conversation> messages, URL url) throws Exception {
        return this.extractTextContent(messages, HttpRequest.get((URL)url).body());
    }
}

