/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.rag.googlesearch;

import com.hankcs.hanlp.HanLP;
import java.util.List;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.rag.Chunk;
import rocks.imsofa.ai.puppychatter.rag.DefaultTextContentExtractor;
import rocks.imsofa.ai.puppychatter.rag.TextContentExtractor;
import rocks.imsofa.ai.puppychatter.rag.googlesearch.GoogleSearchRagHandlerCallback;

public class DefaultGoogleSearchRagHandlerCallback
implements GoogleSearchRagHandlerCallback {
    private String baseQuery;
    private TextContentExtractor htmlPageContentExtractor = new DefaultTextContentExtractor();

    public DefaultGoogleSearchRagHandlerCallback(String baseQuery) {
        this.baseQuery = baseQuery;
    }

    public DefaultGoogleSearchRagHandlerCallback(String baseQuery, TextContentExtractor htmlPageContentExtractor) {
        this.baseQuery = baseQuery;
        this.htmlPageContentExtractor = htmlPageContentExtractor;
    }

    @Override
    public String getQuery(List<Conversation> messages) {
        String conversation = messages.get(messages.size() - 1).getContent();
        List keywords = HanLP.extractKeyword((String)conversation, (int)5);
        String query = this.baseQuery + " \"" + String.join((CharSequence)"\" | \"", keywords) + "\"";
        return query;
    }

    @Override
    public boolean accept(List<Chunk> currentChunks, String link) {
        return true;
    }

    @Override
    public boolean moveOn(List<Chunk> chunks) {
        long totalLength = 0L;
        for (Chunk chunk : chunks) {
            totalLength += (long)chunk.getTextContent().length();
        }
        return totalLength < 10000L;
    }

    @Override
    public TextContentExtractor getHtmlPageContentExtractor() {
        return this.htmlPageContentExtractor;
    }
}

